/*
 * Decompiled with CFR 0.152.
 */
package java_cup.runtime;

import java_cup.runtime.Symbol;
import java_cup.runtime.SymbolFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ComplexSymbolFactory
implements SymbolFactory {
    public Symbol newSymbol(String string, int n, Location location, Location location2, Object object) {
        return new ComplexSymbol(string, n, location, location2, object);
    }

    public Symbol newSymbol(String string, int n, Location location, Location location2) {
        return new ComplexSymbol(string, n, location, location2);
    }

    @Override
    public Symbol newSymbol(String string, int n, Symbol symbol, Object object) {
        return new ComplexSymbol(string, n, symbol, object);
    }

    @Override
    public Symbol newSymbol(String string, int n, Symbol symbol, Symbol symbol2, Object object) {
        return new ComplexSymbol(string, n, symbol, symbol2, object);
    }

    @Override
    public Symbol newSymbol(String string, int n, Symbol symbol, Symbol symbol2) {
        return new ComplexSymbol(string, n, symbol, symbol2);
    }

    @Override
    public Symbol newSymbol(String string, int n) {
        return new ComplexSymbol(string, n);
    }

    @Override
    public Symbol newSymbol(String string, int n, Object object) {
        return new ComplexSymbol(string, n, object);
    }

    @Override
    public Symbol startSymbol(String string, int n, int n2) {
        return new ComplexSymbol(string, n, n2);
    }

    public static class ComplexSymbol
    extends Symbol {
        protected String name;
        public Location xleft;
        public Location xright;

        public ComplexSymbol(String string, int n) {
            super(n);
            this.name = string;
        }

        public ComplexSymbol(String string, int n, Object object) {
            super(n, object);
            this.name = string;
        }

        @Override
        public String toString() {
            if (this.xleft == null || this.xright == null) {
                return "Symbol: " + this.name;
            }
            return "Symbol: " + this.name + " (" + String.valueOf(this.xleft) + " - " + String.valueOf(this.xright) + ")";
        }

        public String getName() {
            return this.name;
        }

        public ComplexSymbol(String string, int n, int n2) {
            super(n, n2);
            this.name = string;
        }

        public ComplexSymbol(String string, int n, Symbol symbol, Symbol symbol2) {
            super(n, symbol, symbol2);
            this.name = string;
            if (symbol != null) {
                this.xleft = ((ComplexSymbol)symbol).xleft;
            }
            if (symbol2 != null) {
                this.xright = ((ComplexSymbol)symbol2).xright;
            }
        }

        public ComplexSymbol(String string, int n, Location location, Location location2) {
            super(n, location.offset, location2.offset);
            this.name = string;
            this.xleft = location;
            this.xright = location2;
        }

        public ComplexSymbol(String string, int n, Symbol symbol, Symbol symbol2, Object object) {
            super(n, symbol.left, symbol2.right, object);
            this.name = string;
            if (symbol != null) {
                this.xleft = ((ComplexSymbol)symbol).xleft;
            }
            if (symbol2 != null) {
                this.xright = ((ComplexSymbol)symbol2).xright;
            }
        }

        public ComplexSymbol(String string, int n, Symbol symbol, Object object) {
            super(n, symbol.right, symbol.right, object);
            this.name = string;
            if (symbol != null) {
                this.xleft = ((ComplexSymbol)symbol).xright;
                this.xright = ((ComplexSymbol)symbol).xright;
            }
        }

        public ComplexSymbol(String string, int n, Location location, Location location2, Object object) {
            super(n, location.offset, location2.offset, object);
            this.name = string;
            this.xleft = location;
            this.xright = location2;
        }

        public Location getLeft() {
            return this.xleft;
        }

        public Location getRight() {
            return this.xright;
        }
    }

    public static class Location {
        private String unit = "unknown";
        private int line;
        private int column;
        private int offset = -1;

        public Location(Location location) {
            this(location.unit, location.line, location.column, location.offset);
        }

        public Location(String string, int n, int n2, int n3) {
            this(string, n, n2);
            this.offset = n3;
        }

        public Location(String string, int n, int n2) {
            this.unit = string;
            this.line = n;
            this.column = n2;
        }

        public Location(int n, int n2, int n3) {
            this(n, n2);
            this.offset = n3;
        }

        public Location(int n, int n2) {
            this.line = n;
            this.column = n2;
        }

        public int getColumn() {
            return this.column;
        }

        public int getLine() {
            return this.line;
        }

        public void move(int n, int n2, int n3) {
            if (this.line >= 0) {
                this.line += n;
            }
            if (this.column >= 0) {
                this.column += n2;
            }
            if (this.offset >= 0) {
                this.offset += n3;
            }
        }

        public static Location clone(Location location) {
            return new Location(location);
        }

        public String getUnit() {
            return this.unit;
        }

        public String toString() {
            return this.getUnit() + ":" + this.getLine() + "/" + this.getColumn() + "(" + this.offset + ")";
        }

        public void toXML(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
            xMLStreamWriter.writeStartElement("location");
            xMLStreamWriter.writeAttribute("compilationunit", this.unit);
            xMLStreamWriter.writeAttribute("orientation", string);
            xMLStreamWriter.writeAttribute("linenumber", "" + this.line);
            xMLStreamWriter.writeAttribute("columnnumber", "" + this.column);
            xMLStreamWriter.writeAttribute("offset", "" + this.offset);
            xMLStreamWriter.writeEndElement();
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

