/*
 * Decompiled with CFR 0.152.
 */
package java_cup.runtime;

import java.util.HashMap;
import java.util.List;
import java_cup.runtime.XMLElement;

public class SyntaxTreeDFS {
    public static void dfs(XMLElement xMLElement, Visitor visitor) {
        visitor.preVisit(xMLElement);
        for (XMLElement xMLElement2 : xMLElement.getChildren()) {
            SyntaxTreeDFS.dfs(xMLElement2, visitor);
        }
        visitor.postVisit(xMLElement);
    }

    public static interface Visitor {
        public void preVisit(XMLElement var1);

        public void postVisit(XMLElement var1);
    }

    public static abstract class AbstractVisitor
    implements Visitor {
        private HashMap<String, ElementHandler> preMap = new HashMap();
        private HashMap<String, ElementHandler> postMap = new HashMap();

        public abstract void defaultPre(XMLElement var1, List<XMLElement> var2);

        public abstract void defaultPost(XMLElement var1, List<XMLElement> var2);

        @Override
        public void preVisit(XMLElement xMLElement) {
            ElementHandler elementHandler = this.preMap.get(xMLElement.tagname);
            if (elementHandler == null) {
                this.defaultPre(xMLElement, xMLElement.getChildren());
            } else {
                elementHandler.handle(xMLElement, xMLElement.getChildren());
            }
        }

        @Override
        public void postVisit(XMLElement xMLElement) {
            ElementHandler elementHandler = this.postMap.get(xMLElement.tagname);
            if (elementHandler == null) {
                this.defaultPost(xMLElement, xMLElement.getChildren());
            } else {
                elementHandler.handle(xMLElement, xMLElement.getChildren());
            }
        }

        public void registerPreVisit(String string, ElementHandler elementHandler) {
            this.preMap.put(string, elementHandler);
        }

        public void registerPostVisit(String string, ElementHandler elementHandler) {
            this.postMap.put(string, elementHandler);
        }
    }

    public static interface ElementHandler {
        public void handle(XMLElement var1, List<XMLElement> var2);
    }
}

