/*
 * Decompiled with CFR 0.152.
 */
package java_cup.runtime;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java_cup.runtime.SyntaxTreeDFS;
import java_cup.runtime.XMLElement;

public class SyntaxTreeTransform {
    private static final XMLElement[] X = new XMLElement[0];

    public static XMLElement flattenLists(XMLElement xMLElement, String ... stringArray) {
        ListFlattener listFlattener = new ListFlattener(stringArray);
        SyntaxTreeDFS.dfs(xMLElement, listFlattener);
        return listFlattener.root();
    }

    public static XMLElement removeUnaryChains(XMLElement xMLElement) {
        ChainRemover chainRemover = new ChainRemover();
        SyntaxTreeDFS.dfs(xMLElement, chainRemover);
        return chainRemover.root();
    }

    private static class ListFlattener
    extends SyntaxTreeDFS.AbstractVisitor {
        private List<String> name;
        private Stack<XMLElement> stack = new Stack();
        private Stack<Integer> intstack = new Stack();

        public ListFlattener(String ... stringArray) {
            this.name = Arrays.asList(stringArray);
        }

        public XMLElement root() {
            System.out.println(this.stack.size() + " - " + this.intstack.size());
            return this.stack.pop();
        }

        @Override
        public void defaultPre(XMLElement xMLElement, List<XMLElement> list) {
            this.intstack.push(list.size());
        }

        @Override
        public void defaultPost(XMLElement xMLElement, List<XMLElement> list) {
            int n = this.intstack.pop();
            if (n > 0) {
                LinkedList<XMLElement> linkedList;
                if (this.name.contains(xMLElement.getTagname())) {
                    for (XMLElement xMLElement2 : list) {
                        if (!xMLElement2.getTagname().equals(xMLElement.getTagname())) continue;
                        break;
                    }
                } else {
                    linkedList = new LinkedList();
                    while (n-- > 0) {
                        linkedList.addFirst(this.stack.pop());
                    }
                    this.stack.push(new XMLElement.NonTerminal(xMLElement.getTagname(), 0, linkedList.toArray(X)));
                    System.out.println("  doch noch: ");
                    return;
                }
                linkedList = new LinkedList<XMLElement>();
                while (n-- > 0) {
                    linkedList.addFirst(this.stack.pop());
                }
                this.stack.addAll(linkedList);
                this.intstack.push(this.intstack.pop() + n - 1);
            }
            if (n == 0) {
                this.stack.push(xMLElement);
            }
        }
    }

    private static class ChainRemover
    extends SyntaxTreeDFS.AbstractVisitor {
        private Stack<XMLElement> stack = new Stack();

        private ChainRemover() {
        }

        public XMLElement root() {
            return this.stack.pop();
        }

        @Override
        public void defaultPost(XMLElement xMLElement, List<XMLElement> list) {
            int n = list.size();
            if (n > 1) {
                LinkedList<XMLElement> linkedList = new LinkedList<XMLElement>();
                while (n-- > 0) {
                    linkedList.addFirst(this.stack.pop());
                }
                XMLElement.NonTerminal nonTerminal = (XMLElement.NonTerminal)xMLElement;
                XMLElement.NonTerminal nonTerminal2 = new XMLElement.NonTerminal(xMLElement.getTagname(), nonTerminal.getVariant(), linkedList.toArray(X));
                this.stack.push(nonTerminal2);
                return;
            }
            if (n == 0) {
                this.stack.push(xMLElement);
            }
        }

        @Override
        public void defaultPre(XMLElement xMLElement, List<XMLElement> list) {
        }
    }
}

