/*
 * Decompiled with CFR 0.152.
 */
package kickass;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import kickass.AssemblerToolbox;
import kickass.common.assmbleinfo.AssembleInfoManager;
import kickass.common.assmbleinfo.OstreamAssembleInfoWriter;
import kickass.common.assmbleinfo.PrintStreamAssembleInfoWriter;
import kickass.common.assmbleinfo.StdOutAssembleInfoWriter;
import kickass.common.diagnostics.IDiagnostic;
import kickass.common.errors.printers.OneLineErrorPrinter;
import kickass.common.errors.printers.StackTraceErrorPrinter;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.output.SymbolFile;
import kickass.common.output.ViceSymbolFile;
import kickass.common.outputmanager.FileOutputManager;
import kickass.nonasm.tools.StringUtil;
import kickass.nonasm.tools.Timer;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.metanodes.AsmNodeList;
import kickass.pass.asmnode.metanodes.AsmNodePair;
import kickass.pass.asmnode.metanodes.NamespaceNode;
import kickass.pass.asmnode.metanodes.ScopeAndSymbolPageNode;
import kickass.pass.asmnode.output.reciever.MainOutputReciever;
import kickass.pass.function.Function;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.pass.values.HashtableValue;
import kickass.plugins.interf.autoincludefile.AutoIncludeFile;
import kickass.plugins.interf.autoincludefile.IAutoIncludeFile;
import kickass.setup.KickAssemblerSetup;
import kickass.setup.configuration.optionparser.KickAssemblerConfigFileUtil;
import kickass.setup.configuration.optionparser.KickAssemblerOptionsConfigParser;
import kickass.setup.configuration.optionparser.KickAssemblerPluginConfigParser;
import kickass.setup.configuration.parameters.KickAssemblerParameters;
import kickass.setup.configuration.parameters.KickAssemblerParametersParser;
import kickass.state.AssertManager;
import kickass.state.EvaluationState;
import kickass.state.libraries.ILibrary;
import kickass.state.libraries.LibConstant;
import kickass.state.miscoutput.ByteDumpWriter;
import kickass.state.scope.symboltable.SymbolStatus;

public class KickAssembler {
    private static final String AUTO_INCLUDED_FILE = "/include/autoinclude.asm";
    private static final String CONFIG_FILE = "/KickAss.cfg";
    private static final String PLUGIN_FILE = "/KickAss.plugin";
    private EvaluationState state = new EvaluationState();

    public static void main(String[] stringArray) {
        System.exit(new KickAssembler().execute(stringArray));
    }

    public static int main2(String[] stringArray) {
        return new KickAssembler().execute(stringArray);
    }

    private int execute(String[] stringArray) {
        this.state.log.addPrintStream(System.out);
        this.state.log.println("//------------------------------------------------------");
        this.state.log.println("//------------------------------------------------------");
        this.state.log.println("//" + StringUtil.centerPad(54, "Kick Assembler v" + KickAssemblerSetup.versionString + " by Mads Nielsen"));
        this.state.log.println("//------------------------------------------------------");
        this.state.log.println("//------------------------------------------------------");
        int n = 0;
        try {
            try {
                this.gatherParameters(this.state, stringArray);
            }
            finally {
                this.state.log.setSilentMode(this.state.parameters.silentMode);
                this.state.log.releaseDelay();
            }
            this.assemble(this.state);
        }
        catch (AsmErrorException asmErrorException) {
            IDiagnostic iDiagnostic = asmErrorException.getError();
            if (!asmErrorException.isRegistered) {
                this.state.diagnosticMgr.add(iDiagnostic);
                iDiagnostic.setCallStack(this.state.callStack);
            }
            this.state.log.error(StackTraceErrorPrinter.instance.printError(iDiagnostic, this.state));
            n = 1;
        }
        catch (Exception exception) {
            this.state.log.error(exception);
            n = 1;
        }
        return n |= this.printAsmInfo(this.state);
    }

    private void gatherParameters(EvaluationState evaluationState, String[] stringArray) throws IOException {
        String[] stringArray2;
        KickAssemblerParameters kickAssemblerParameters = evaluationState.parameters;
        File file = new File(".");
        kickAssemblerParameters.libPath.add(file);
        KickAssemblerPluginConfigParser.parsePluginFile(PLUGIN_FILE, evaluationState);
        String[] stringArray3 = KickAssemblerOptionsConfigParser.parseOptionConfigFile(CONFIG_FILE);
        KickAssemblerParametersParser kickAssemblerParametersParser = new KickAssemblerParametersParser(evaluationState.log);
        kickAssemblerParametersParser.parseArgs(stringArray3, kickAssemblerParameters);
        kickAssemblerParametersParser.parseArgs(stringArray, kickAssemblerParameters);
        if (kickAssemblerParameters.inputFileName == null) {
            throw new AsmErrorException("No inputfile supplied.");
        }
        if (!new File(kickAssemblerParameters.inputFileName).exists()) {
            throw new AsmErrorException("Inputfile '" + kickAssemblerParameters.inputFileName + "' doesn't exist.");
        }
        File file2 = evaluationState.fileMgr.getFileOrFail(kickAssemblerParameters.inputFileName, true, null);
        File file3 = file2.getCanonicalFile().getParentFile();
        evaluationState.fileMgr.setCurrentDirectory(file3);
        for (String string : stringArray2 = kickAssemblerParameters.extraCfgFilenames.toArray(new String[0])) {
            File file4 = KickAssemblerConfigFileUtil.getUserSpecifiedConfigFile(string, file3);
            if (file4 == null) {
                evaluationState.log.println("Warning. Can't find configfile : " + string);
                continue;
            }
            String[] stringArray4 = KickAssemblerOptionsConfigParser.parseOptionConfigFile(file4);
            new KickAssemblerParametersParser(evaluationState.log).parseArgs(stringArray4, kickAssemblerParameters);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void assemble(EvaluationState evaluationState) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        void var7_13;
        File file = Paths.get(".", new String[0]).normalize().toFile();
        KickAssemblerParameters kickAssemblerParameters = evaluationState.parameters;
        evaluationState.segmentMgr.defaultSegment.setAllowOverlappingMemoryBlocks(kickAssemblerParameters.allowOverlappingMemoryblocks);
        File file2 = evaluationState.fileMgr.getCurrentDirectory();
        if (kickAssemblerParameters.outputDir != null) {
            boolean bl = new File(kickAssemblerParameters.outputDir).isAbsolute();
            file2 = bl ? new File(kickAssemblerParameters.outputDir) : new File(file2, kickAssemblerParameters.outputDir);
        }
        evaluationState.outputMgr = new FileOutputManager(file2, kickAssemblerParameters.allowFileOutput, kickAssemblerParameters.noOutput);
        evaluationState.log.println("Output dir: " + file2.getAbsolutePath());
        if (kickAssemblerParameters.displayLibraries) {
            this.displayLibraries(KickAssemblerSetup.getStdLibararies());
            return;
        }
        evaluationState.log.setDebugging(kickAssemblerParameters.debug);
        evaluationState.log.setWarnings(kickAssemblerParameters.warnings);
        evaluationState.fileMgr.setSourceLibraryPath(kickAssemblerParameters.libPath);
        evaluationState.fileMgr.setFileReplacementMap(kickAssemblerParameters.fileReplacementMap);
        HashtableValue hashtableValue = new HashtableValue().addStringValues(kickAssemblerParameters.cmdLineArguments);
        hashtableValue.lock(null);
        evaluationState.pluginMgr.registerPlugin(new AutoIncludeFile("KickAss.jar", this.getClass(), AUTO_INCLUDED_FILE));
        evaluationState.namespaceMgr.getSystemNamespace().getScope().defineErrorIfExist("cmdLineVars", iValueHolderArray -> new ConstantValueHolder(hashtableValue), evaluationState, "ERROR! cmdLineVars is already defined", null).setStatus(SymbolStatus.defined);
        for (ILibrary object62 : KickAssemblerSetup.getStdLibararies()) {
            evaluationState.namespaceMgr.addLibrary(object62, evaluationState.namespaceMgr.getSystemNamespace());
        }
        for (Object object5 : KickAssemblerSetup.getStdPlugins()) {
            evaluationState.pluginMgr.registerPlugin(object5);
        }
        Set<String> set = evaluationState.preprocessorMgr.getDefinedSymbols();
        set.addAll(evaluationState.parameters.defines);
        String string = new File(kickAssemblerParameters.inputFileName).getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            String string2 = string.substring(0, n);
        }
        evaluationState.c64OutputMgr.inputfileWithoutExt = var7_13;
        if (kickAssemblerParameters.outputfile == null) {
            var9_15 = kickAssemblerParameters.binFile ? ".bin" : ".prg";
            kickAssemblerParameters.outputfile = (String)var7_13 + (String)var9_15;
        } else {
            var9_15 = new File(kickAssemblerParameters.outputfile);
            if (!((File)var9_15).isAbsolute()) {
                var9_15 = new File(file, kickAssemblerParameters.outputfile);
            }
            kickAssemblerParameters.outputfile = ((File)var9_15).toPath().normalize().toString();
        }
        long l = System.nanoTime();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("User Arguments: ");
        for (Map.Entry<String, String> entry : kickAssemblerParameters.cmdLineArguments.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(entry.getKey() + "=" + entry.getValue());
        }
        if (!bl) {
            evaluationState.log.println(stringBuffer.toString());
        }
        evaluationState.log.println("parsing");
        long l2 = System.nanoTime();
        evaluationState.prepareNewPass();
        AsmNode asmNode = AssemblerToolbox.loadAndLexOrError(kickAssemblerParameters.inputFileName, evaluationState, null);
        if (asmNode == null) {
            return;
        }
        asmNode = new NamespaceNode(asmNode, evaluationState.namespaceMgr.getRootNamespace());
        asmNode = asmNode.executeMetaRegistrations(evaluationState);
        ArrayList<AsmNode> arrayList = new ArrayList<AsmNode>();
        for (IAutoIncludeFile iAutoIncludeFile : evaluationState.pluginMgr.getAutoIncludeFiles()) {
            object4 = iAutoIncludeFile.openStream();
            AsmNode asmNode2 = AssemblerToolbox.loadAndLexOrError((InputStream)object4, (String)(object3 = iAutoIncludeFile.getDefinition().getJarName() + ":" + iAutoIncludeFile.getDefinition().getFilePath()), evaluationState, null);
            if (asmNode2 == null) continue;
            asmNode2 = new NamespaceNode(asmNode2, evaluationState.namespaceMgr.getSystemNamespace());
            arrayList.add(asmNode2);
        }
        Object object6 = new AsmNodeList(arrayList);
        object6 = ((AsmNode)object6).executeMetaRegistrations(evaluationState);
        AsmNodePair asmNodePair = new AsmNodePair((AsmNode)object6, asmNode);
        object3 = object4 = new ScopeAndSymbolPageNode(asmNodePair, evaluationState.namespaceMgr.getSystemNamespace().getScope());
        long l3 = System.nanoTime();
        object3 = ((AsmNode)object3).executePrepass(evaluationState);
        this.printErrorsAndTerminate(evaluationState, false);
        if (kickAssemblerParameters.noEval) {
            evaluationState.log.println("Preparse done and no evaluation requested. Exiting.");
            return;
        }
        long l4 = System.nanoTime();
        do {
            evaluationState.prepareNewPass();
            evaluationState.log.println("flex pass " + evaluationState.getPassNo());
            object3 = ((AsmNode)object3).executePass(evaluationState);
            evaluationState.segmentMgr.postPassExecution();
            this.printErrorsAndTerminate(evaluationState, false);
            if (evaluationState.getMadeMetaProgress() || ((AsmNode)object3).isFinished()) continue;
            evaluationState.prepareNewPass();
            evaluationState.setFailOnInvalidValue(true);
            object3 = ((AsmNode)object3).executePass(evaluationState);
            throw new AsmErrorException("Made no progress and can't solve the program.. You should have gotten an error. Contact the author!", null);
        } while (!((AsmNode)object3).isFinished());
        evaluationState.log.println("Output pass");
        MainOutputReciever mainOutputReciever = new MainOutputReciever(evaluationState.outputMgr, evaluationState.log);
        ((AsmNode)object3).deliverOutput(mainOutputReciever);
        mainOutputReciever.finish();
        long l5 = System.nanoTime();
        evaluationState.segmentMgr.postPassesExecution();
        this.printErrorsAndTerminate(evaluationState, false);
        if (kickAssemblerParameters.byteDump) {
            new ByteDumpWriter().printSegments(kickAssemblerParameters.byteDumpFile, evaluationState);
        }
        long l6 = System.nanoTime();
        evaluationState.c64OutputMgr.postPassExecution();
        this.printErrorsAndTerminate(evaluationState, false);
        long l7 = System.nanoTime();
        evaluationState.segmentMgr.doOutputAfterPasses();
        this.printErrorsAndTerminate(evaluationState, true);
        long l8 = System.nanoTime();
        if (kickAssemblerParameters.time) {
            evaluationState.log.println("Parse time  = " + (l3 - l2) / 1000000L + " ms");
            evaluationState.log.println("PrePass time  = " + (l4 - l3) / 1000000L + " ms");
            evaluationState.log.println("Evaluations passes time  = " + (l5 - l4) / 1000000L + " ms");
            evaluationState.log.println("C64 output(disk,files) = " + (l7 - l6) / 1000000L + " ms");
            evaluationState.log.println("Total assemble time = " + (l8 - l) / 1000000L + " ms");
        }
        Timer.printTimers(evaluationState.log);
        AssertManager assertManager = evaluationState.assertMgr;
        if (assertManager.getNoOfAsserts() > 0) {
            evaluationState.log.println();
            object2 = assertManager.getNoOfFailedAsserts() == 0 ? " failed" : " FAILED!";
            evaluationState.log.println("Made " + assertManager.getNoOfAsserts() + " asserts , " + assertManager.getNoOfFailedAsserts() + (String)object2);
        }
        if (kickAssemblerParameters.viceSymbols) {
            object2 = new File((String)var7_13).getName() + ".vs";
            object = new File(kickAssemblerParameters.outputfile).getParent();
            String string3 = (String)(object == null ? "" : (String)object + File.separator) + (String)object2;
            evaluationState.log.println("Writing Vice symbol file: " + string3);
            new ViceSymbolFile().writeFile(string3, evaluationState);
        }
        if (kickAssemblerParameters.symbolFile) {
            if (kickAssemblerParameters.symbolFileOutputDir == null) {
                object2 = (String)var7_13 + ".sym";
            } else {
                object = new File((String)var7_13).getName() + ".sym";
                object2 = kickAssemblerParameters.symbolFileOutputDir + File.separator + (String)object;
            }
            evaluationState.log.println("Writing Symbol file: " + (String)object2);
            evaluationState.namespaceMgr.getSystemNamespace().getScope().getSymbolTable().setCurrentPage(((ScopeAndSymbolPageNode)object4).getSymbolPage());
            new SymbolFile(evaluationState.namespaceMgr.getRootNamespace()).writeFile((String)object2, evaluationState);
        }
        this.executeOnSuccess(kickAssemblerParameters.executeOnSuccess, true, file2, evaluationState);
        this.executeOnSuccess(kickAssemblerParameters.executeOnSuccessNoArg, false, file2, evaluationState);
    }

    private void executeOnSuccess(String string, boolean bl, File file, EvaluationState evaluationState) {
        Object object;
        if (string == null) {
            return;
        }
        Object object2 = null;
        if (bl && (object = evaluationState.c64OutputMgr.getExecuteFileCandidate()) != null) {
            boolean bl2 = new File((String)object).isAbsolute();
            object2 = bl2 ? object : new File(file, (String)object).toPath().toString();
        }
        try {
            object = new StringTokenizer(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
            if (object2 != null) {
                arrayList.add((String)object2);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.directory(file);
            if (evaluationState.parameters.executeLog != null) {
                File file2 = new File(evaluationState.parameters.executeLog);
                if (!file2.isAbsolute()) {
                    file2 = new File(file, evaluationState.parameters.executeLog);
                }
                ProcessBuilder.Redirect redirect = ProcessBuilder.Redirect.to(file2);
                processBuilder.redirectOutput(redirect);
                processBuilder.redirectError(redirect);
            }
            processBuilder.start();
        }
        catch (Exception exception) {
            evaluationState.log.error("Error while executing external program: " + String.valueOf(exception));
        }
    }

    private int printAsmInfo(EvaluationState evaluationState) {
        Object object;
        boolean bl = evaluationState.parameters.assembleInfos.isEmpty();
        if (bl) {
            return 0;
        }
        PrintStreamAssembleInfoWriter printStreamAssembleInfoWriter = null;
        boolean bl2 = evaluationState.parameters.assembleInfoToStdOut;
        if (bl2) {
            printStreamAssembleInfoWriter = new StdOutAssembleInfoWriter();
        } else {
            object = evaluationState.parameters.assembleInfoFilename;
            try {
                OutputStream outputStream = evaluationState.outputMgr.OpenOutputStream((String)object, false);
                printStreamAssembleInfoWriter = new OstreamAssembleInfoWriter(outputStream);
            }
            catch (Exception exception) {
                evaluationState.log.error("Could not create asminfo file: " + (String)object);
                return 1;
            }
        }
        object = new AssembleInfoManager(printStreamAssembleInfoWriter);
        printStreamAssembleInfoWriter.open();
        ((AssembleInfoManager)object).WriteInfo(evaluationState);
        printStreamAssembleInfoWriter.close();
        return 0;
    }

    private void displayLibraries(List<ILibrary> list) {
        this.state.log.println("DEFAULT CONSTANTS:");
        for (ILibrary iLibrary : list) {
            for (LibConstant object : iLibrary.getConstants()) {
                this.state.log.println(object.getName());
            }
        }
        this.state.log.println();
        this.state.log.println("DEFAULT FUNCTIONS:");
        for (ILibrary iLibrary : list) {
            for (Function function : iLibrary.getFunctions()) {
                this.state.log.println(function.getName());
            }
        }
    }

    private void printErrorsAndTerminate(EvaluationState evaluationState, boolean bl) {
        boolean bl2;
        int n = evaluationState.diagnosticMgr.getErrors().size();
        int n2 = evaluationState.diagnosticMgr.getWarnings().size();
        boolean bl3 = bl2 = n == 0 && (n2 == 0 || !bl);
        if (bl2) {
            return;
        }
        int n3 = n + n2;
        if (n3 > 1 || n2 > 0 && bl) {
            boolean bl4;
            int n4;
            evaluationState.log.println("Got " + n + " errors and " + n2 + " warnings while executing:");
            int n5 = n4 = evaluationState.parameters.showMaxNoOfDiagnostics;
            for (int i = 0; n5 > 0 && i < n; --n5, ++i) {
                IDiagnostic iDiagnostic = evaluationState.diagnosticMgr.getErrors().get(i);
                evaluationState.log.println("  " + OneLineErrorPrinter.instance.printError(iDiagnostic, evaluationState));
            }
            for (int i = 0; n5 > 0 && i < n2; --n5, ++i) {
                IDiagnostic iDiagnostic = evaluationState.diagnosticMgr.getWarnings().get(i);
                evaluationState.log.println("  " + OneLineErrorPrinter.instance.printError(iDiagnostic, evaluationState));
            }
            boolean bl5 = bl4 = n3 > n4;
            if (bl4) {
                evaluationState.log.println("  ...");
            }
        }
        evaluationState.log.println();
        if (n > 0) {
            throw new AsmErrorException(evaluationState.diagnosticMgr.getErrors().get(0), true);
        }
    }
}

