/*
 * Decompiled with CFR 0.152.
 */
package kickass._65xx;

import kickass._65xx._65xxArgType;
import kickass._65xx._65xxArgumentExpr;
import kickass._65xx._65xxParsedArg;
import kickass.common.diagnostics.AsmError;
import kickass.common.diagnostics.AsmWarning;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.values.LabelValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.pass.values._65xxArgumentValue;
import kickass.state.EvaluationState;
import kickass.state.scope.ResolvedSymbol;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.segments.SegmentMemoryBlock;

public class _65xxMnemonicNode
extends AsmDirective {
    private String mnemonic;
    private _65xxArgumentExpr argExpr;
    private int[] modes;
    private _65xxArgType argType;
    private String argLabelName;
    private ForceMode forceMode;
    private boolean hasNotUsedZpMode;
    private ISymbolPageIdx argLabelsymbolPageIdx;
    private boolean labelIsResolved = false;
    private SegmentMemoryBlock.Entry memEntry;

    private static _65xxArgType resolveExtension(String string, SourceRange sourceRange, EvaluationState evaluationState) {
        if (string.equals("imm") || string.equals("im")) {
            return _65xxArgType.immediate;
        }
        if (string.equals("zpx") || string.equals("zx")) {
            return _65xxArgType.zeropageX;
        }
        if (string.equals("zpy") || string.equals("zy")) {
            return _65xxArgType.zeropageY;
        }
        if (string.equals("izpx") || string.equals("izx")) {
            return _65xxArgType.indirectZeropageX;
        }
        if (string.equals("izpy") || string.equals("izy")) {
            return _65xxArgType.indirectZeropageY;
        }
        if (string.equals("absx") || string.equals("ax")) {
            return _65xxArgType.absoluteX;
        }
        if (string.equals("absy") || string.equals("ay")) {
            return _65xxArgType.absoluteY;
        }
        if (string.equals("ind") || string.equals("i")) {
            return _65xxArgType.indirect;
        }
        if (string.equals("rel") || string.equals("r")) {
            return _65xxArgType.relative;
        }
        evaluationState.diagnosticMgr.add(new AsmError("Unknown extension: " + string, sourceRange));
        return null;
    }

    public static _65xxMnemonicNode createNode(String string, String string2, _65xxParsedArg _65xxParsedArg2, int[] nArray, String string3, SourceRange sourceRange, EvaluationState evaluationState) {
        ForceMode forceMode = null;
        _65xxArgType _65xxArgType2 = null;
        if (string2 != null) {
            if (string2.equals("zp") || string2.equals("z")) {
                forceMode = ForceMode.zp;
            } else if (string2.equals("abs") || string2.equals("a")) {
                forceMode = ForceMode.abs;
            } else {
                _65xxArgType2 = _65xxMnemonicNode.resolveExtension(string2, sourceRange, evaluationState);
                if (_65xxArgType2 == null) {
                    return null;
                }
            }
        }
        boolean bl = _65xxParsedArg2.type == _65xxArgType.unresolvedAbsolute;
        _65xxArgumentExpr _65xxArgumentExpr2 = new _65xxArgumentExpr(_65xxParsedArg2.type, _65xxParsedArg2.expr1, _65xxParsedArg2.expr2, bl);
        return new _65xxMnemonicNode(string, _65xxArgType2, _65xxArgumentExpr2, nArray, string3, forceMode, sourceRange);
    }

    public _65xxMnemonicNode(String string, _65xxArgType _65xxArgType2, _65xxArgumentExpr _65xxArgumentExpr2, int[] nArray, String string2, ForceMode forceMode, SourceRange sourceRange) {
        super(sourceRange);
        this.argExpr = _65xxArgumentExpr2;
        this.mnemonic = string;
        this.argType = _65xxArgType2;
        this.modes = nArray;
        this.argLabelName = string2;
        this.forceMode = forceMode;
    }

    private _65xxMnemonicNode(_65xxMnemonicNode _65xxMnemonicNode2) {
        super(_65xxMnemonicNode2.range);
        this.argExpr = _65xxMnemonicNode2.argExpr;
        this.mnemonic = _65xxMnemonicNode2.mnemonic;
        this.argType = _65xxMnemonicNode2.argType;
        this.modes = _65xxMnemonicNode2.modes;
        this.argLabelName = _65xxMnemonicNode2.argLabelName;
        this.argLabelsymbolPageIdx = _65xxMnemonicNode2.argLabelsymbolPageIdx;
        this.forceMode = _65xxMnemonicNode2.forceMode;
    }

    @Override
    public AsmNode copy() {
        return new _65xxMnemonicNode(this);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        if (this.argLabelName != null) {
            boolean bl = this.argLabelName.startsWith("@");
            String string = bl ? this.argLabelName.substring(1) : this.argLabelName;
            SymbolScope symbolScope = evaluationState.scopeMgr.getRootOrCurrentScope(bl);
            if (symbolScope.isDefined(string)) {
                evaluationState.diagnosticMgr.add(new AsmError("The symbol '" + string + "' is already defined", this.range));
                return this;
            }
            this.argLabelsymbolPageIdx = symbolScope.define(string, LabelValue.getInitializer(evaluationState));
            this.argLabelsymbolPageIdx.setStatus(SymbolStatus.defined);
            this.argLabelsymbolPageIdx.setIsScopeExposed(true);
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.argExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        int n;
        Object object;
        int n2;
        int n3;
        _65xxArgType _65xxArgType2;
        int n4;
        Value value;
        Value value2;
        Value value3;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        if (this.memEntry == null) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
            if (this.argLabelName != null) {
                LabelValue labelValue = (LabelValue)this.argLabelsymbolPageIdx.getValueHolder().getWithoutSideeffect();
                labelValue.resolveSegment(evaluationState.segmentMgr.getCurrentSegment().getBank());
            }
        }
        boolean bl = false;
        if (this.argLabelName != null && !this.labelIsResolved) {
            int n5 = evaluationState.segmentMgr.getMemoryPosition();
            if (n5 < 0) {
                bl = true;
            } else {
                value3 = (LabelValue)this.argLabelsymbolPageIdx.getValueHolder().getWithoutSideeffect();
                ((LabelValue)value3).resolveLabel(new NumberValue(n5 + 1));
                evaluationState.scopeMgr.addResolvedSymbol(new ResolvedSymbol(this.argLabelName, n5 + 1, evaluationState.segmentMgr.getCurrentSegment(), this.range));
                evaluationState.setMadeMetaProgress();
                this.labelIsResolved = true;
            }
        }
        Long l = (value2 = ((_65xxArgumentValue)(value3 = _65xxArgumentValue.get65xxArg(value = this.argExpr.evaluate(evaluationState), this.range))).getValue()).isInvalid() || ((_65xxArgumentValue)value3).get65xxArgType() == _65xxArgType.noArgument ? null : Long.valueOf(value2.getLong(this.argExpr.valueExpr.getSourceRange()));
        boolean bl2 = value2.isZeropageBound();
        if (this.argType == null) {
            this.argType = ((_65xxArgumentValue)value3).get65xxArgType();
            int n6 = n4 = this.forceMode == ForceMode.zp ? 1 : 0;
            if (n4 != 0) {
                _65xxArgType2 = this.argType.getZpForm();
                if (_65xxArgType2 == null) {
                    throw new AsmErrorException("Cannot force zeropage mode on an argument of type " + this.argType.name(), this.range);
                }
                int n7 = n3 = this.getMode(_65xxArgType2.getIdNo(), this.modes) != -1 ? 1 : 0;
                if (n3 == 0) {
                    throw new AsmErrorException("'" + this.mnemonic + "' does not support mode '" + _65xxArgType2.name() + "'", this.range);
                }
            }
        }
        if (!this.argType.isResolved()) {
            _65xxArgType _65xxArgType3 = this.argType;
            this.argType = this.resolveArgType(this.argType, l, bl2, this.modes);
            if (l == null) {
                _65xxArgType2 = _65xxArgType3.getZpForm();
                n3 = _65xxArgType2 != null && this.getMode(_65xxArgType2.getIdNo(), this.modes) >= 0 ? 1 : 0;
                this.hasNotUsedZpMode = n3 != 0 && _65xxArgType2 != this.argType;
            }
        }
        n4 = 1 + this.argType.getByteSize();
        evaluationState.segmentMgr.increaseMemoryPosition(n4);
        this.memEntry.setNoOfBytes(n4);
        int n8 = this.argType.getIdNo();
        int n9 = n3 = this.modes.length <= n8 ? -1 : this.modes[this.argType.getIdNo()];
        if (n3 == -1) {
            throw new AsmErrorException("invalid adressingmode. '" + this.mnemonic + "' doesn't support " + String.valueOf((Object)this.argType) + " mode", this.range);
        }
        if (value2.isInvalid()) {
            return this;
        }
        if (this.argType == _65xxArgType.relative) {
            n2 = evaluationState.segmentMgr.getMemoryPosition();
            if (n2 < 0) {
                return this;
            }
            if ((l = Long.valueOf(l - (long)n2)) < -128L || 127L < l) {
                throw new AsmErrorException("relative address is illegal (jump distance is too far: " + l + ").", this.argExpr.valueExpr.getSourceRange());
            }
        }
        if (this.argType == _65xxArgType.zeropageRelative) {
            Value value4 = ((_65xxArgumentValue)value3).getValue2();
            if (value4.isInvalid()) {
                return this;
            }
            object = value4.getInt(this.range);
            n = evaluationState.segmentMgr.getMemoryPosition();
            if (n < 0) {
                return this;
            }
            if ((Integer)(object = Integer.valueOf((Integer)object - n)) < -128 || 127 < (Integer)object) {
                throw new AsmErrorException("relative address is illegal (jump distance is too far).", this.argExpr.valueExpr2.getSourceRange());
            }
            l = l & 0xFFL | (long)(((Integer)object & 0xFF) << 8);
        }
        if (bl || evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        int n10 = n2 = this.hasNotUsedZpMode && 0L <= l && l < 256L ? 1 : 0;
        if (n2 != 0) {
            evaluationState.diagnosticMgr.add(new AsmWarning("Using absolute mode for zeropage argument. Try defining involved labels before this statement.", this.range));
        }
        object = new byte[n4];
        object[0] = (byte)n3;
        for (n = 1; n < n4; ++n) {
            object[n] = (byte)(l & 0xFFL);
            l = l >> 8;
        }
        this.memEntry.fillEntry((byte[])object, this.range);
        evaluationState.setMadeMetaProgress();
        return SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }

    private _65xxArgType resolveArgType(_65xxArgType _65xxArgType2, Long l, boolean bl, int[] nArray) {
        boolean bl2;
        boolean bl3;
        if (this.forceMode == ForceMode.abs) {
            return _65xxArgType2.getAbsForm();
        }
        _65xxArgType _65xxArgType3 = _65xxArgType2.getZpForm();
        boolean bl4 = _65xxArgType3 != null && this.getMode(_65xxArgType3.getIdNo(), nArray) >= 0;
        boolean bl5 = bl3 = l != null && l <= 255L;
        if (bl4 && (bl || bl3 || this.forceMode == ForceMode.zp)) {
            return _65xxArgType3;
        }
        boolean bl6 = this.getMode(_65xxArgType.relative.getIdNo(), nArray) >= 0;
        boolean bl7 = bl2 = _65xxArgType2.getRelForm() != null;
        if (bl6 && bl2) {
            return _65xxArgType.relative;
        }
        return _65xxArgType2.getAbsForm();
    }

    private int getMode(int n, int[] nArray) {
        if (n >= nArray.length) {
            return -1;
        }
        return nArray[n];
    }

    @Override
    public String toString() {
        return this.mnemonic;
    }

    private static enum ForceMode {
        abs,
        zp;

    }
}

