/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.log;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class Logger {
    private boolean debuggingOn = true;
    private boolean warningsOn = true;
    private boolean silentMode = false;
    private boolean delayOn = true;
    private List<String> delayedLines = new ArrayList<String>();
    private List<PrintStream> printStreams = new ArrayList<PrintStream>();

    public Logger(boolean bl) {
        this.delayOn = bl;
    }

    public void setSilentMode(boolean bl) {
        this.silentMode = bl;
    }

    public void releaseDelay() {
        if (!this.delayOn) {
            return;
        }
        this.delayOn = false;
        for (String string : this.delayedLines) {
            this.printlnToAllStreams(string);
        }
        this.delayedLines.clear();
    }

    public void setDebugging(boolean bl) {
        this.debuggingOn = bl;
    }

    public void setWarnings(boolean bl) {
        this.warningsOn = bl;
    }

    public void addPrintStream(PrintStream printStream) {
        this.printStreams.add(printStream);
    }

    private void printlnToAllStreams(String string) {
        if (this.delayOn) {
            this.delayedLines.add(string);
            return;
        }
        if (this.silentMode) {
            return;
        }
        for (int i = 0; i < this.printStreams.size(); ++i) {
            this.printStreams.get(i).println(string);
        }
    }

    public void println() {
        this.printlnToAllStreams("");
    }

    public void println(String string) {
        this.printlnToAllStreams(string);
    }

    public void mark(String string) {
        if (this.debuggingOn) {
            this.printlnToAllStreams(string);
        }
    }

    public void warn(String string) {
        if (this.warningsOn) {
            this.printlnToAllStreams(string);
        }
    }

    public void error(Exception exception) {
        this.printlnToAllStreams(exception.getMessage());
        if (this.debuggingOn) {
            exception.printStackTrace(System.out);
        }
    }

    public void error(String string) {
        this.printlnToAllStreams(string);
    }
}

