/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.output;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kickass.state.EvaluationState;
import kickass.state.breakpoint.Breakpoint;
import kickass.state.breakpoint.Watchpoint;
import kickass.state.scope.ResolvedSymbol;

public class ViceSymbolFile {
    private Set<String> validDestinations = new HashSet<String>(Arrays.asList("c", "8", "9", "10", "11"));

    public void writeFile(String string, EvaluationState evaluationState) {
        try {
            OutputStream outputStream = evaluationState.outputMgr.OpenOutputStream(string, false);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            this.writeSymbols(evaluationState.scopeMgr.getResolvedSymbols(), bufferedWriter);
            this.writeBreakpoints(evaluationState.breakpointMgr.getAllBreakpoints(), bufferedWriter);
            this.writeWatchpoints(evaluationState.breakpointMgr.getAllWatchpoints(), bufferedWriter);
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            evaluationState.log.error("IO error while writing vice symbol file '" + string + "':" + iOException.getMessage());
        }
        catch (Exception exception) {
            evaluationState.log.error("Internal error while writing vice symbol file '" + string + "'. Contact the author");
            exception.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSymbols(List<ResolvedSymbol> list, Writer writer) throws Exception {
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        for (ResolvedSymbol object52 : list) {
            void var7_9;
            List list2;
            object2 = object52.name;
            if (((String)object2).startsWith("@")) {
                object2 = ((String)object2).substring(1);
            }
            if ((list2 = (List)hashMap.get(object2)) == null) {
                ArrayList arrayList = new ArrayList();
                hashMap.put((Comparator<ViceLabel>)object2, arrayList);
            }
            var7_9.add(object52);
        }
        int n = 0;
        ArrayList<ViceLabel> arrayList = new ArrayList<ViceLabel>();
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object3 = (String)entry.getKey();
            object = (List)entry.getValue();
            boolean bl = object.size() > 1;
            int n2 = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string;
                ResolvedSymbol resolvedSymbol = (ResolvedSymbol)iterator.next();
                Object object4 = object3;
                if (bl) {
                    object4 = (String)object4 + "__" + n2++;
                }
                if (!this.validDestinations.contains(string = resolvedSymbol.segment.getDestination())) {
                    string = "c";
                }
                n = Math.max(n, string.length());
                arrayList.add(new ViceLabel(string, resolvedSymbol.address, (String)object4));
            }
        }
        object2 = Comparator.comparing(ViceLabel::destination).thenComparing(ViceLabel::addr);
        arrayList.sort((Comparator<ViceLabel>)object2);
        for (Object object3 : arrayList) {
            object = String.format("%4s", Integer.toHexString(((ViceLabel)object3).addr));
            String string = String.format("%" + n + "s", ((ViceLabel)object3).destination);
            writer.write("al " + string + ": " + (String)object + " ." + ((ViceLabel)object3).name + "\n");
        }
    }

    private void writeBreakpoints(List<Breakpoint> list, Writer writer) throws Exception {
        for (Breakpoint breakpoint : list) {
            String string = breakpoint.argument;
            if (string == null) {
                string = "";
            }
            writer.write("break " + Integer.toHexString(breakpoint.address) + " " + string + "\n");
        }
    }

    private void writeWatchpoints(List<Watchpoint> list, Writer writer) throws Exception {
        for (Watchpoint watchpoint : list) {
            String string = Integer.toHexString(watchpoint.address1) + " ";
            String string2 = watchpoint.address2 == null ? "" : Integer.toHexString(watchpoint.address2) + " ";
            String string3 = watchpoint.argument == null ? "" : watchpoint.argument + " ";
            writer.write("watch " + string3 + string + string2 + "\n");
        }
    }

    record ViceLabel(String destination, int addr, String name) {
    }
}

