/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.baselang;

import java.io.IOException;
import java.io.Reader;
import kickass.common.diagnostics.AsmError;
import kickass.common.syntaxinfo.SyntaxInfo;
import kickass.common.syntaxinfo.SyntaxType;
import kickass.nonasm.c64.CharToPetsciiConverter;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.EosToken;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokens.OperatorToken;
import kickass.parsing.baselang.tokens.ValueToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;

public class BaseLangLexer
implements ITokenStream {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int STRING = 2;
    public static final int ESC_STRING = 4;
    public static final int MULTILINE_COMMENT = 6;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u001c\u0001\u001b\u00011\u00012\u0001\u001a\u0012\u0000\u0001\u001c\u0001\u0013\u0001\u0019\u0001&\u0001\u0004\u0001\u0006\u0001,\u0001\u0016\u0001 \u0001!\u0001\u001f\u0001\u0014\u0001(\u0001\u0015\u0001\u0003\u0001\u001d\u0002\u0007\b\u0001\u0001/\u0001)\u0001+\u0001'\u0001*\u00010\u0001\u0011\u0006\u0005\u0014\u0012\u0001$\u0001\u0017\u0001%\u0001-\u0001\u0002\u0001\u0000\u0001\r\u0001\u0018\u0002\u0005\u0001\u000b\u0001\f\u0005\u0012\u0001\u000e\u0001\u0012\u0001\u0010\u0003\u0012\u0001\t\u0001\u000f\u0001\b\u0001\n\u0005\u0012\u0001\"\u0001\u001e\u0001#\u0001.\u0006\u0000\u00011\u1fa2\u0000\u00011\u00011\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000";
    private static final char[] ZZ_CMAP = BaseLangLexer.zzUnpackCMap("\t\u0000\u0001\u001c\u0001\u001b\u00011\u00012\u0001\u001a\u0012\u0000\u0001\u001c\u0001\u0013\u0001\u0019\u0001&\u0001\u0004\u0001\u0006\u0001,\u0001\u0016\u0001 \u0001!\u0001\u001f\u0001\u0014\u0001(\u0001\u0015\u0001\u0003\u0001\u001d\u0002\u0007\b\u0001\u0001/\u0001)\u0001+\u0001'\u0001*\u00010\u0001\u0011\u0006\u0005\u0014\u0012\u0001$\u0001\u0017\u0001%\u0001-\u0001\u0002\u0001\u0000\u0001\r\u0001\u0018\u0002\u0005\u0001\u000b\u0001\f\u0005\u0012\u0001\u000e\u0001\u0012\u0001\u0010\u0003\u0012\u0001\t\u0001\u000f\u0001\b\u0001\n\u0005\u0012\u0001\"\u0001\u001e\u0001#\u0001.\u0006\u0000\u00011\u1fa2\u0000\u00011\u00011\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000");
    private static final int[] ZZ_ACTION = BaseLangLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0004\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0002\u0001\u0003\u0003\u0001\u0001\u0001\u0005\u0001\u0006\u0001\u0007\u0001\u0001\u0001\b\u0002\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0002!\u0001\u001f\u0001\u0000\u0002\"\u0002\u0000\u0001#\u0001$\u0003\u0003\u0001%\u0001\u0000\u0002&\u0001'\u0001(\u0001)\u0001*\u0001+\u0002\u0000\u0001,\u0001-\u0001.\u0001/\u00010\u00011\u00012\u00013\u00014\u00015\u00016\u00017\u00028\u00019\u0001:\u0001;\u0001<\u0001=\u0001>\u0001?\u0001@\u0001\u0002\u0002\u0000\u0003\u0003\u0001A\u0005\u0000\u0001A\u0002\u0000\u0001,\u0002\u0000\u0001B\u0001C\u0001\u0000\u0001D\u0001E\u0001F\u0001G\u0001H\u0001I\u0001J\u0001K\u0001\u0000\u0001L";
    private static final int[] ZZ_ROWMAP = BaseLangLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00003\u0000f\u0000\u0099\u0000\u00cc\u0000\u00ff\u0000\u0132\u0000\u00cc\u0000\u0165\u0000\u0198\u0000\u01cb\u0000\u01fe\u0000\u0231\u0000\u0264\u0000\u0297\u0000\u02ca\u0000\u02fd\u0000\u0330\u0000\u00cc\u0000\u0363\u0000\u00cc\u0000\u0396\u0000\u03c9\u0000\u03fc\u0000\u042f\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u0462\u0000\u00cc\u0000\u00cc\u0000\u0495\u0000\u04c8\u0000\u04fb\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u052e\u0000\u00cc\u0000\u0561\u0000\u00cc\u0000\u0594\u0000\u05c7\u0000\u00cc\u0000\u05fa\u0000\u062d\u0000\u0660\u0000\u0693\u0000\u06c6\u0000\u06f9\u0000\u072c\u0000\u075f\u0000\u00cc\u0000\u0792\u0000\u07c5\u0000\u07f8\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u082b\u0000\u085e\u0000\u0891\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u08c4\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u08f7\u0000\u0693\u0000\u06c6\u0000\u092a\u0000\u095d\u0000\u0990\u0000\u00cc\u0000\u09c3\u0000\u09f6\u0000\u0a29\u0000\u0a5c\u0000\u0a8f\u0000\u0ac2\u0000\u0af5\u0000\u0b28\u0000\u00cc\u0000\u0b5b\u0000\u08f7\u0000\u0132\u0000\u0132\u0000\u0b8e\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u00cc\u0000\u0bc1\u0000\u00cc";
    private static final int[] ZZ_TRANS = BaseLangLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\u0007\u0001\n\u0001\u0006\u0001\u000b\u0003\u0007\u0001\f\u0003\u0007\u0001\r\u0001\u000e\u0001\u0007\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0005\u0001\u0007\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001&\u0001'\u0001(\u0001)\u0001*\u0001\u0005\u0001\u0016\u0019+\u0001,\u0001-\u0001.\u0017+\u0017/\u00010\u0001/\u0001,\u0001-\u0001.\u0017/\u001f1\u00012\u001314\u0000\u0001\u0006\u00013\u00014\u0003\u0000\u0001\u0006,\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\n\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u001b\u0000\u00015\u0003\u0000\u00015\u0001\u0000\u00015\u0003\u0000\u00035\n\u0000\u00015!\u0000\u00016,\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0002\u0007\u00017\u0007\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u001b\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0006\u0007\u00018\u0003\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u001b\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0003\u0007\u00019\u0006\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u001c\u0000\u0001\u0007\u0002\u0000\u0001\u0007\u0002\u0000\t\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u0001:\u001b\u0000\u0001;\u0002\u0000\u0001;\u0002\u0000\t;\u0001\u0000\u0001;\u0001\u0000\u0001<\u0001=\u0002\u0000\u0001;\u000e\u0000\u0001>\u001f\u0000\u0001?\u0012\u0000\u0001@ \u0000\u0001A\u0011\u0000\u0001B\u000b\u0000\u0017C\u0001D\u001bC\u001b\u0000\u0001\u00153\u0000\u0001\u0016\u0015\u0000\u0001\u0016\u001d\u0000\u0001E\u0001\u0000\u0001F\u0007\u0000\u0001G)\u0000\u0001H;\u0000\u0001I2\u0000\u0001J\u0002\u0000\u0001K/\u0000\u0001L\u0002\u0000\u0001M/\u0000\u0001N\u0003\u0000\u0001O3\u0000\u0001P\u0006\u0000\u0019+\u0003\u0000\u0017+\u001b\u0000\u0001.\u0017\u0000\u0017/\u0001\u0000\u0001/\u0003\u0000\u0017/\u0004Q\u0001R\u0003Q\u0001S\u0001T\u0002Q\u0001U\u0003Q\u0001V\u0006Q\u0001W\u0001X\u0001Y\u0002\u0000\u0015Q\u001f\u0000\u0001Z\u0016\u0000\u0001\u0006\u00013\u0004\u0000\u0001\u0006,\u0000\u0001[\u0005\u0000\u0001[,\u0000\u00015\u0001\\\u0002\u0000\u00015\u0001\u0000\u00015\u0003\u0000\u00035\n\u0000\u00015\u001c\u0000\u0001]\u0004\u0000\u00016,\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0003\u0007\u0001^\u0006\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u001b\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0007\u0007\u0001_\u0002\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u001b\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0007\u0007\u0001`\u0002\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u001b\u0000\u0002;\u0002\u0000\u0001;\u0001\u0000\n;\u0001\u0000\u0001;\u0001\u0000\u0001<\u0001=\u0002\u0000\u0001;.\u0000\u0001<3\u0000\u0001=3\u0000\u0001a \u0000\u0001b\u0003\u0000\u0001c\u0001d\u0002\u0000\u0001e\u0003\u0000\u0001f\u0005\u0000\u0001g\u0001h\u0001i\u001a\u0000\u001aE\u0002j\u0017E\u0001\u0000\u0001k\u0003\u0000\u0001k\u0001\u0000\u0001k\u0003\u0000\u0003k\n\u0000\u0001k\u001b\u0000\u0001[\u0001l\u0004\u0000\u0001[,\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0004\u0007\u0001m\u0005\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u001b\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\b\u0007\u0001^\u0001\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u001b\u0000\u0002\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0007\u0007\u0001n\u0002\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u0001\u0007\u001b\u0000\u0001o\u0003\u0000\u0001o\u0001\u0000\u0001o\u0003\u0000\u0003o\n\u0000\u0001o0\u0000\u0001p2\u0000\u0001q2\u0000\u0001r2\u0000\u0001s2\u0000\u0001t2\u0000\u0001u2\u0000\u0001v\u001d\u0000\u0001w\u0003\u0000\u0001w\u0001\u0000\u0001w\u0003\u0000\u0003w\n\u0000\u0001w\u001b\u0000\u0001x\u0003\u0000\u0001x\u0001\u0000\u0001x\u0003\u0000\u0003x\n\u0000\u0001x0\u0000\u0001y\u001c\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = BaseLangLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0004\u0000\u0001\t\u0002\u0001\u0001\t\n\u0001\u0001\t\u0001\u0001\u0001\t\u0004\u0001\u0007\t\u0001\u0001\u0002\t\u0003\u0001\u0004\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0002\u0000\u0005\u0001\u0001\t\u0001\u0000\u0002\u0001\u0005\t\u0002\u0000\u0001\u0001\f\t\u0001\u0001\b\t\u0001\u0001\u0002\u0000\u0003\u0001\u0001\t\u0005\u0000\u0001\u0001\u0002\u0000\u0001\t\u0002\u0000\u0002\u0001\u0001\u0000\b\t\u0001\u0000\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int zzFinalHighSurrogate = 0;
    StringBuffer string = new StringBuffer();
    SourceRange stringStartQuoteRange = null;
    SourceRange startMlineCommentRange = null;
    private String filename;
    private SourceRange fixedSourceRange;
    private EvaluationState state;
    private IToken terminatingToken = EosToken.instance;

    private static int[] zzUnpackAction() {
        int[] nArray = new int[121];
        int n = 0;
        n = BaseLangLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAction(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackRowMap() {
        int[] nArray = new int[121];
        int n = 0;
        n = BaseLangLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackRowMap(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++) << 16;
            nArray[n3++] = n5 | string.charAt(n2++);
        }
        return n3;
    }

    private static int[] zzUnpackTrans() {
        int[] nArray = new int[3060];
        int n = 0;
        n = BaseLangLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackTrans(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            int n6 = string.charAt(n2++);
            do {
                nArray[n3++] = --n6;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackAttribute() {
        int[] nArray = new int[121];
        int n = 0;
        n = BaseLangLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAttribute(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setFixedSourceRange(SourceRange sourceRange) {
        this.fixedSourceRange = sourceRange;
    }

    public void setState(EvaluationState evaluationState) {
        this.state = evaluationState;
    }

    @Override
    public IToken getTerminatingToken() {
        return this.terminatingToken;
    }

    private void addError(String string, SourceRange sourceRange) {
        this.state.diagnosticMgr.add(new AsmError(string, sourceRange));
    }

    private SourceRange getSourceRange() {
        if (this.fixedSourceRange != null) {
            return this.fixedSourceRange;
        }
        return new SourceRange(this.yyline + 1, this.yycolumn + 1, this.yyline + 1, this.yycolumn + this.yytext().length(), this.filename);
    }

    private IToken createToken(TokenType tokenType) {
        return new OperatorToken(tokenType, this.getSourceRange());
    }

    private IToken createToken(TokenType tokenType, SourceRange sourceRange) {
        return new OperatorToken(tokenType, sourceRange);
    }

    private IToken createToken(TokenType tokenType, Object object) {
        return new ValueToken(tokenType, object, this.getSourceRange());
    }

    private IToken createToken(TokenType tokenType, Object object, SourceRange sourceRange) {
        return new ValueToken(tokenType, object, sourceRange);
    }

    public BaseLangLexer(Reader reader) {
        this.zzReader = reader;
    }

    private static char[] zzUnpackCMap(String string) {
        char[] cArray = new char[0x110000];
        int n = 0;
        int n2 = 0;
        while (n < 162) {
            int n3 = string.charAt(n++);
            char c = string.charAt(n++);
            do {
                cArray[n2++] = c;
            } while (--n3 > 0);
        }
        return cArray;
    }

    private boolean zzRefill() throws IOException {
        int n;
        int n2;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] cArray = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, cArray, 0, this.zzBuffer.length);
            this.zzBuffer = cArray;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((n2 = this.zzReader.read(this.zzBuffer, this.zzEndRead, n = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples for workaround.");
        }
        if (n2 > 0) {
            this.zzEndRead += n2;
            if (n2 == n && Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                --this.zzEndRead;
                this.zzFinalHighSurrogate = 1;
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.zzFinalHighSurrogate = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int n) {
        this.zzLexicalState = n;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int n) {
        return this.zzBuffer[this.zzStartRead + n];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int n) {
        String string;
        try {
            string = ZZ_ERROR_MSG[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = ZZ_ERROR_MSG[0];
        }
        throw new Error(string);
    }

    public void yypushback(int n) {
        if (n > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= n;
    }

    @Override
    public IToken next() throws IOException {
        int n = this.zzEndRead;
        char[] cArray = this.zzBuffer;
        char[] cArray2 = ZZ_CMAP;
        int[] nArray = ZZ_TRANS;
        int[] nArray2 = ZZ_ROWMAP;
        int[] nArray3 = ZZ_ATTRIBUTE;
        block170: while (true) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = this.zzMarkedPos;
            boolean bl = false;
            block171: for (n5 = this.zzStartRead; n5 < n7; n5 += n6) {
                int n8 = Character.codePointAt(cArray, n5, n7);
                n6 = Character.charCount(n8);
                switch (n8) {
                    case 11: 
                    case 12: 
                    case 133: 
                    case 8232: 
                    case 8233: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        bl = false;
                        continue block171;
                    }
                    case 13: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        bl = true;
                        continue block171;
                    }
                    case 10: {
                        if (bl) {
                            bl = false;
                            continue block171;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block171;
                    }
                    default: {
                        bl = false;
                        this.yycolumn += n6;
                    }
                }
            }
            if (bl) {
                if (n7 < n) {
                    n4 = cArray[n7] == '\n' ? 1 : 0;
                } else if (this.zzAtEOF) {
                    n4 = 0;
                } else {
                    n3 = this.zzRefill();
                    n = this.zzEndRead;
                    n7 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    if (n3 != 0) {
                        n4 = 0;
                    } else {
                        int n9 = n4 = cArray[n7] == '\n' ? 1 : 0;
                    }
                }
                if (n4 != 0) {
                    --this.yyline;
                }
            }
            int n10 = -1;
            this.zzCurrentPos = this.zzStartRead = n7;
            n5 = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            n4 = nArray3[this.zzState];
            if ((n4 & 1) == 1) {
                n10 = this.zzState;
            }
            while (true) {
                if (n5 < n) {
                    n2 = Character.codePointAt(cArray, n5, n);
                    n5 += Character.charCount(n2);
                } else {
                    if (this.zzAtEOF) {
                        n2 = -1;
                        break;
                    }
                    this.zzCurrentPos = n5;
                    this.zzMarkedPos = n7;
                    n3 = this.zzRefill();
                    n5 = this.zzCurrentPos;
                    n7 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    n = this.zzEndRead;
                    if (n3 != 0) {
                        n2 = -1;
                        break;
                    }
                    n2 = Character.codePointAt(cArray, n5, n);
                    n5 += Character.charCount(n2);
                }
                n3 = nArray[nArray2[this.zzState] + cArray2[n2]];
                if (n3 == -1) break;
                this.zzState = n3;
                n4 = nArray3[this.zzState];
                if ((n4 & 1) != 1) continue;
                n10 = this.zzState;
                n7 = n5;
                if ((n4 & 8) == 8) break;
            }
            this.zzMarkedPos = n7;
            if (n2 == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 2: {
                        this.yybegin(0);
                        SourceRange sourceRange = new SourceRange(this.stringStartQuoteRange, this.getSourceRange());
                        this.addError("Unterminated string", sourceRange);
                        return this.createToken(TokenType.StringQuote, this.string.toString(), sourceRange);
                    }
                    case 122: {
                        continue block170;
                    }
                    case 4: {
                        this.yybegin(0);
                        SourceRange sourceRange = new SourceRange(this.stringStartQuoteRange, this.getSourceRange());
                        this.addError("Unterminated string", sourceRange);
                        return this.createToken(TokenType.StringQuote, this.string.toString(), sourceRange);
                    }
                    case 123: {
                        continue block170;
                    }
                    case 6: {
                        this.yybegin(0);
                        SourceRange sourceRange = new SourceRange(this.startMlineCommentRange, this.getSourceRange());
                        this.addError("Unterminated comment", sourceRange);
                        return this.createToken(TokenType.StdWhitespace, sourceRange);
                    }
                    case 124: {
                        continue block170;
                    }
                }
                this.terminatingToken = new EosToken(SourceRange.createEofRange(this.yyline + 1, this.yycolumn + 1, this.filename));
                return this.terminatingToken;
            }
            switch (n10 < 0 ? n10 : ZZ_ACTION[n10]) {
                case 1: {
                    return this.createToken(TokenType.UnknownChar);
                }
                case 77: {
                    continue block170;
                }
                case 2: {
                    String string = this.yytext();
                    if (string.indexOf(95) >= 0) {
                        string = string.replace("_", "");
                    }
                    return this.createToken(TokenType.Number, Double.valueOf(string));
                }
                case 78: {
                    continue block170;
                }
                case 3: {
                    return this.createToken(TokenType.Id, this.yytext());
                }
                case 79: {
                    continue block170;
                }
                case 4: {
                    return this.createToken(TokenType.Dot);
                }
                case 80: {
                    continue block170;
                }
                case 5: {
                    return this.createToken(TokenType.Not);
                }
                case 81: {
                    continue block170;
                }
                case 6: {
                    return this.createToken(TokenType.Plus);
                }
                case 82: {
                    continue block170;
                }
                case 7: {
                    return this.createToken(TokenType.Minus);
                }
                case 83: {
                    continue block170;
                }
                case 8: {
                    this.string.setLength(0);
                    this.stringStartQuoteRange = this.getSourceRange();
                    this.yybegin(2);
                }
                case 84: {
                    continue block170;
                }
                case 9: {
                    return this.createToken(TokenType.Newline);
                }
                case 85: {
                    continue block170;
                }
                case 10: {
                    return this.createToken(TokenType.StdWhitespace);
                }
                case 86: {
                    continue block170;
                }
                case 11: {
                    return this.createToken(TokenType.Divide);
                }
                case 87: {
                    continue block170;
                }
                case 12: {
                    return this.createToken(TokenType.BitOr);
                }
                case 88: {
                    continue block170;
                }
                case 13: {
                    return this.createToken(TokenType.Times);
                }
                case 89: {
                    continue block170;
                }
                case 14: {
                    return this.createToken(TokenType.LParan);
                }
                case 90: {
                    continue block170;
                }
                case 15: {
                    return this.createToken(TokenType.RParan);
                }
                case 91: {
                    continue block170;
                }
                case 16: {
                    return this.createToken(TokenType.LCBracket);
                }
                case 92: {
                    continue block170;
                }
                case 17: {
                    return this.createToken(TokenType.RCBracket);
                }
                case 93: {
                    continue block170;
                }
                case 18: {
                    return this.createToken(TokenType.LSBracket);
                }
                case 94: {
                    continue block170;
                }
                case 19: {
                    return this.createToken(TokenType.RSBracket);
                }
                case 95: {
                    continue block170;
                }
                case 20: {
                    return this.createToken(TokenType.Hash);
                }
                case 96: {
                    continue block170;
                }
                case 21: {
                    return this.createToken(TokenType.Assign);
                }
                case 97: {
                    continue block170;
                }
                case 22: {
                    return this.createToken(TokenType.Comma);
                }
                case 98: {
                    continue block170;
                }
                case 23: {
                    return this.createToken(TokenType.Semi);
                }
                case 99: {
                    continue block170;
                }
                case 24: {
                    return this.createToken(TokenType.Greater);
                }
                case 100: {
                    continue block170;
                }
                case 25: {
                    return this.createToken(TokenType.Less);
                }
                case 101: {
                    continue block170;
                }
                case 26: {
                    return this.createToken(TokenType.BitAnd);
                }
                case 102: {
                    continue block170;
                }
                case 27: {
                    return this.createToken(TokenType.BitXor);
                }
                case 103: {
                    continue block170;
                }
                case 28: {
                    return this.createToken(TokenType.BitNot);
                }
                case 104: {
                    continue block170;
                }
                case 29: {
                    return this.createToken(TokenType.Colon);
                }
                case 105: {
                    continue block170;
                }
                case 30: {
                    return this.createToken(TokenType.Questionmark);
                }
                case 106: {
                    continue block170;
                }
                case 31: {
                    this.string.append(this.yytext());
                }
                case 107: {
                    continue block170;
                }
                case 32: {
                    this.yybegin(0);
                    SourceRange sourceRange = new SourceRange(this.stringStartQuoteRange, this.getSourceRange());
                    return this.createToken(TokenType.StringQuote, this.string.toString(), sourceRange);
                }
                case 108: {
                    continue block170;
                }
                case 33: {
                    this.yybegin(0);
                    SourceRange sourceRange = new SourceRange(this.stringStartQuoteRange, this.getSourceRange());
                    this.addError("Unterminated string", sourceRange);
                    return this.createToken(TokenType.StringQuote, this.string.toString(), sourceRange);
                }
                case 109: {
                    continue block170;
                }
                case 34: 
                case 110: {
                    continue block170;
                }
                case 35: {
                    long l = 0L;
                    String string = this.yytext().substring(1);
                    if (string.indexOf(95) >= 0) {
                        string = string.replace("_", "");
                    }
                    try {
                        l = Long.parseUnsignedLong(string, 16);
                    }
                    catch (Exception exception) {
                        this.addError("Invalid hex string", this.getSourceRange());
                    }
                    return this.createToken(TokenType.Number, l);
                }
                case 111: {
                    continue block170;
                }
                case 36: {
                    long l = 0L;
                    String string = this.yytext().substring(1);
                    if (string.indexOf(95) >= 0) {
                        string = string.replace("_", "");
                    }
                    try {
                        l = Long.parseUnsignedLong(string, 2);
                    }
                    catch (Exception exception) {
                        this.addError("Invalid binary string", this.getSourceRange());
                    }
                    return this.createToken(TokenType.Number, l);
                }
                case 112: {
                    continue block170;
                }
                case 37: {
                    this.string.setLength(0);
                    this.stringStartQuoteRange = this.getSourceRange();
                    this.yybegin(4);
                }
                case 113: {
                    continue block170;
                }
                case 38: {
                    return this.createToken(TokenType.LocalLabelId, this.yytext());
                }
                case 114: {
                    continue block170;
                }
                case 39: {
                    return this.createToken(TokenType.NotEqual);
                }
                case 115: {
                    continue block170;
                }
                case 40: {
                    return this.createToken(TokenType.PlusPlus);
                }
                case 116: {
                    continue block170;
                }
                case 41: {
                    return this.createToken(TokenType.PlusEqual);
                }
                case 117: {
                    continue block170;
                }
                case 42: {
                    return this.createToken(TokenType.MinusMinus);
                }
                case 118: {
                    continue block170;
                }
                case 43: {
                    return this.createToken(TokenType.MinusEqual);
                }
                case 119: {
                    continue block170;
                }
                case 44: {
                    this.state.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.comment, this.getSourceRange()));
                    return this.createToken(TokenType.Newline);
                }
                case 120: {
                    continue block170;
                }
                case 45: {
                    this.startMlineCommentRange = this.getSourceRange();
                    this.yybegin(6);
                }
                case 121: {
                    continue block170;
                }
                case 46: {
                    return this.createToken(TokenType.DivideEqual);
                }
                case 122: {
                    continue block170;
                }
                case 47: {
                    return this.createToken(TokenType.Or);
                }
                case 123: {
                    continue block170;
                }
                case 48: {
                    return this.createToken(TokenType.TimesEqual);
                }
                case 124: {
                    continue block170;
                }
                case 49: {
                    return this.createToken(TokenType.Equal);
                }
                case 125: {
                    continue block170;
                }
                case 50: {
                    return this.createToken(TokenType.LambdaArrow);
                }
                case 126: {
                    continue block170;
                }
                case 51: {
                    return this.createToken(TokenType.GreaterEqual);
                }
                case 127: {
                    continue block170;
                }
                case 52: {
                    return this.createToken(TokenType.ShiftRight);
                }
                case 128: {
                    continue block170;
                }
                case 53: {
                    return this.createToken(TokenType.LessEqual);
                }
                case 129: {
                    continue block170;
                }
                case 54: {
                    return this.createToken(TokenType.ShiftLeft);
                }
                case 130: {
                    continue block170;
                }
                case 55: {
                    return this.createToken(TokenType.And);
                }
                case 131: {
                    continue block170;
                }
                case 56: {
                    this.addError("Unknown escape code", this.getSourceRange());
                }
                case 132: {
                    continue block170;
                }
                case 57: {
                    this.string.append('\t');
                }
                case 133: {
                    continue block170;
                }
                case 58: {
                    this.string.append('\r');
                }
                case 134: {
                    continue block170;
                }
                case 59: {
                    this.string.append('\f');
                }
                case 135: {
                    continue block170;
                }
                case 60: {
                    this.string.append('\n');
                }
                case 136: {
                    continue block170;
                }
                case 61: {
                    this.string.append('\\');
                }
                case 137: {
                    continue block170;
                }
                case 62: {
                    this.string.append('\b');
                }
                case 138: {
                    continue block170;
                }
                case 63: {
                    this.string.append('\"');
                }
                case 139: {
                    continue block170;
                }
                case 64: {
                    this.yybegin(0);
                    SourceRange sourceRange = new SourceRange(this.startMlineCommentRange, this.getSourceRange());
                    this.state.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.comment, sourceRange));
                    return this.createToken(TokenType.StdWhitespace, sourceRange);
                }
                case 140: {
                    continue block170;
                }
                case 65: {
                    String string = this.yytext();
                    return this.createToken(TokenType.CharQuote, Character.valueOf(string.charAt(1)));
                }
                case 141: {
                    continue block170;
                }
                case 66: {
                    return this.createToken(TokenType.Boolean, this.yytext().equals("true"));
                }
                case 142: {
                    continue block170;
                }
                case 67: {
                    return this.createToken(TokenType.Null);
                }
                case 143: {
                    continue block170;
                }
                case 68: {
                    return this.createToken(TokenType.CharQuote, Character.valueOf('\t'));
                }
                case 144: {
                    continue block170;
                }
                case 69: {
                    return this.createToken(TokenType.CharQuote, Character.valueOf('\r'));
                }
                case 145: {
                    continue block170;
                }
                case 70: {
                    return this.createToken(TokenType.CharQuote, Character.valueOf('\f'));
                }
                case 146: {
                    continue block170;
                }
                case 71: {
                    return this.createToken(TokenType.CharQuote, Character.valueOf('\n'));
                }
                case 147: {
                    continue block170;
                }
                case 72: {
                    return this.createToken(TokenType.CharQuote, Character.valueOf('\''));
                }
                case 148: {
                    continue block170;
                }
                case 73: {
                    return this.createToken(TokenType.CharQuote, Character.valueOf('\\'));
                }
                case 149: {
                    continue block170;
                }
                case 74: {
                    return this.createToken(TokenType.CharQuote, Character.valueOf('\b'));
                }
                case 150: {
                    continue block170;
                }
                case 75: {
                    String string = this.yytext().substring(2);
                    long l = Long.parseUnsignedLong(string, 16);
                    this.string.append((char)(l += (long)CharToPetsciiConverter.valueStartChar));
                }
                case 151: {
                    continue block170;
                }
                case 76: {
                    String string = this.yytext().substring(3, 5);
                    long l = Long.parseUnsignedLong(string, 16);
                    return this.createToken(TokenType.CharQuote, Character.valueOf((char)(l += (long)CharToPetsciiConverter.valueStartChar)));
                }
                case 152: {
                    continue block170;
                }
            }
            this.zzScanError(1);
        }
    }
}

