/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.baselang.tokens;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.state.EvaluationState;

public interface IToken {
    public Object getValue();

    public TokenType getType();

    public SourceRange getSourceRange();

    public IToken getRangeStartToken();

    public IToken getRangeEndToken();

    public List<IToken> getChildren();

    public TokenStreamList getChildStream();

    public boolean isId(String var1);

    public boolean isIdIgnoreCase(String var1);

    public String getStringValue();

    default public StringRange getStringRange() {
        String string = this.getStringValue();
        if (string == null) {
            return null;
        }
        return new StringRange(string, this.getSourceRange());
    }

    default public boolean isEos() {
        return false;
    }

    default public boolean expectType(TokenType tokenType, EvaluationState evaluationState, String string) {
        if (this.getType() == tokenType) {
            return true;
        }
        evaluationState.diagnosticMgr.add(new AsmError(string, this.getSourceRange()));
        return false;
    }

    default public boolean expectId(EvaluationState evaluationState) {
        return this.expectType(TokenType.Id, evaluationState, "Token must be an identifer");
    }

    default public boolean expectEos(EvaluationState evaluationState) {
        return this.expectType(TokenType.Eos, evaluationState, "Unexpected token");
    }
}

