/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.baselang.tokenstreams;

import java.util.List;
import kickass.parsing.baselang.TokenCategory;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.EosToken;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;

public class TokenStreamList
implements ITokenStream {
    private int currentIdx;
    private int reverseCurrentIdx;
    private List<IToken> list;
    private IToken terminatingToken;

    public TokenStreamList(List<IToken> list, IToken iToken) {
        this.list = list;
        this.terminatingToken = iToken;
        this.currentIdx = -1;
        this.reverseCurrentIdx = list.size();
    }

    public IToken get(int n) {
        if (this.list.size() <= n) {
            return new EosToken(this.terminatingToken.getSourceRange());
        }
        if (n < 0) {
            return EosToken.instance;
        }
        return this.list.get(n);
    }

    public TokenType getType(int n) {
        return this.list.get(n).getType();
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public IToken next() {
        return this.get(++this.currentIdx);
    }

    @Override
    public IToken peek() {
        return this.get(this.currentIdx + 1);
    }

    @Override
    public IToken peek2() {
        return this.get(this.currentIdx + 2);
    }

    @Override
    public IToken peekSkipWs() {
        IToken iToken = this.get(this.currentIdx + 1);
        if (iToken.getType() != TokenType.StdWhitespace) {
            return iToken;
        }
        return this.get(this.currentIdx + 2);
    }

    @Override
    public IToken peekSkipWsAndNl() {
        IToken iToken = this.get(this.currentIdx + 1);
        if (iToken.getType().getCategory() != TokenCategory.whitespace) {
            return iToken;
        }
        return this.get(this.currentIdx + 2);
    }

    @Override
    public IToken nextSkipWs() {
        IToken iToken = this.next();
        while (iToken.getType() == TokenType.StdWhitespace) {
            iToken = this.next();
        }
        return iToken;
    }

    @Override
    public IToken getTerminatingToken() {
        return this.terminatingToken;
    }

    public IToken nextOfType(TokenType tokenType) {
        IToken iToken = this.next();
        while (!iToken.isEos() && iToken.getType() != tokenType) {
            iToken = this.next();
        }
        return iToken;
    }

    public int getIndex() {
        return this.currentIdx;
    }

    public void setIndex(int n) {
        this.currentIdx = n;
    }

    public void setIndexs(int n, int n2) {
        this.currentIdx = n;
        this.reverseCurrentIdx = n2;
    }

    public void setReverseIndexs(int n) {
        this.reverseCurrentIdx = n;
    }

    public int getReverseIndex() {
        return this.reverseCurrentIdx;
    }

    public IToken reverseNext() {
        return this.get(--this.reverseCurrentIdx);
    }

    public IToken reverseNextNoWs() {
        IToken iToken = this.reverseNext();
        boolean bl = iToken.getType() == TokenType.StdWhitespace;
        return bl ? this.reverseNext() : iToken;
    }
}

