/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kickass._65xx._65xxArgParser;
import kickass._65xx._65xxArgType;
import kickass._65xx._65xxArgumentExpr;
import kickass._65xx._65xxParsedArg;
import kickass.common.diagnostics.AsmError;
import kickass.common.syntaxinfo.SyntaxInfo;
import kickass.common.syntaxinfo.SyntaxType;
import kickass.nonasm.util.functions.Func2;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokens.SubFileToken;
import kickass.parsing.baselang.tokens.TokenUtil;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.IDirectiveParser;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.misc.NamespacePathParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelConnectorNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.BracketScopeDirective;
import kickass.pass.asmnode.metanodes.AsmNodeList;
import kickass.pass.asmnode.metanodes.FileImportNode;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;
import kickass.state.namespace.NamespacePath;

public class MainParser
implements IDirectiveParser<AsmNode> {
    private Map<String, Map<String, ITailParser<AsmNode>>> cpuToMnemonics = new HashMap<String, Map<String, ITailParser<AsmNode>>>();
    private Map<String, ITailParser<AsmNode>> mnemonicSubParsers;
    private Map<String, ITailParser<AsmNode>> subParsers = new HashMap<String, ITailParser<AsmNode>>();
    private IDirectiveParser<AsmNode> scopeNodeParser;
    private BiFunction<String, SourceRange, AsmNode> labelNodeCreator;
    private BiFunction<String, SourceRange, AsmNode> multiLabelNodeCreator;
    private Func2<NamespacePath, List<ExprNode>, AsmNode> macroExecNodeCreator;
    private Func2<NamespacePath, List<ExprNode>, AsmNode> pseudoCommandNodeCreator;
    private ITailParser<AsmNode> starParser;

    public void setCpusMnemonics(Map<String, Map<String, ITailParser<AsmNode>>> map) {
        this.cpuToMnemonics = map;
    }

    public boolean setCpu(String string) {
        if (!this.cpuToMnemonics.containsKey(string)) {
            return false;
        }
        this.mnemonicSubParsers = this.cpuToMnemonics.get(string);
        return true;
    }

    public MainParser setScopeNodeParser(IDirectiveParser<AsmNode> iDirectiveParser) {
        this.scopeNodeParser = iDirectiveParser;
        return this;
    }

    public void setMacroExecNodeCreator(Func2<NamespacePath, List<ExprNode>, AsmNode> func2) {
        this.macroExecNodeCreator = func2;
    }

    public void setPseudoCmdExecNodeCreator(Func2<NamespacePath, List<ExprNode>, AsmNode> func2) {
        this.pseudoCommandNodeCreator = func2;
    }

    public void setStarParser(ITailParser<AsmNode> iTailParser) {
        this.starParser = iTailParser;
    }

    public void setLabelCreator(BiFunction<String, SourceRange, AsmNode> biFunction) {
        this.labelNodeCreator = biFunction;
    }

    public void setMultiLabelCreator(BiFunction<String, SourceRange, AsmNode> biFunction) {
        this.multiLabelNodeCreator = biFunction;
    }

    public void addSubPaser(String string, ITailParser<AsmNode> iTailParser) {
        this.subParsers.put(string, iTailParser);
    }

    @Override
    public AsmNode parse(ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        return this.parse(iTokenStream, evaluationState, true);
    }

    public AsmNode parse(ITokenStream iTokenStream, EvaluationState evaluationState, boolean bl) throws IOException {
        boolean bl2;
        boolean bl3;
        iTokenStream.skipWsAndNl();
        IToken iToken = iTokenStream.peek();
        TokenType tokenType = iToken.getType();
        if (iToken.isEos()) {
            return null;
        }
        IToken iToken2 = iTokenStream.peek2();
        TokenType tokenType2 = iToken2.getType();
        if (tokenType == TokenType.Id) {
            if (tokenType2 == TokenType.Colon) {
                IToken iToken3 = iTokenStream.next();
                SourceRange sourceRange = new SourceRange(iToken3.getSourceRange(), iTokenStream.next().getSourceRange());
                evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.label, sourceRange));
                return this.labelNodeCreator.apply(iToken3.getStringValue(), sourceRange);
            }
            if (tokenType2 == TokenType.ParanthesisRange) {
                NamespacePath namespacePath = NamespacePathParser.parse(iTokenStream, true, evaluationState);
                if (namespacePath == null) {
                    return null;
                }
                evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.macroExecution, namespacePath.entityIdRange));
                return this.parseMacroExecution(namespacePath, iTokenStream, evaluationState);
            }
            String string = iToken.getStringValue();
            ITailParser<AsmNode> iTailParser = this.mnemonicSubParsers.get(string);
            if (iTailParser != null) {
                IToken iToken4 = iTokenStream.next();
                return iTailParser.parse(iToken4, iToken4.getSourceRange(), iTokenStream, evaluationState);
            }
            ITailParser<AsmNode> iTailParser2 = this.subParsers.get(string);
            if (iTailParser2 != null) {
                IToken iToken5 = iTokenStream.next();
                return iTailParser2.parse(iToken5, iToken5.getSourceRange(), iTokenStream, evaluationState);
            }
            NamespacePath namespacePath = NamespacePathParser.parse(iTokenStream, true, evaluationState);
            if (namespacePath == null) {
                return null;
            }
            iToken = iTokenStream.peek();
            if (iTokenStream.peek().getType() == TokenType.ParanthesisRange) {
                evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.macroExecution, namespacePath.entityIdRange));
                return this.parseMacroExecution(namespacePath, iTokenStream, evaluationState);
            }
            return this.parsePseudocommandExecution(namespacePath, iTokenStream, evaluationState);
        }
        boolean bl4 = bl3 = tokenType == TokenType.Dot && tokenType2 == TokenType.Id;
        if (bl3) {
            IToken iToken6 = iTokenStream.next();
            IToken iToken7 = iTokenStream.next();
            SourceRange sourceRange = new SourceRange(iToken6.getSourceRange(), iToken7.getSourceRange());
            evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.directive, sourceRange));
            ITailParser<AsmNode> iTailParser = this.subParsers.get("." + iToken7.getStringValue());
            if (iTailParser == null) {
                evaluationState.diagnosticMgr.add(new AsmError("Invalid directive", sourceRange));
                iTokenStream.getUntilSemiOrNl();
                return null;
            }
            return iTailParser.parse(iToken7, sourceRange, iTokenStream, evaluationState);
        }
        boolean bl5 = bl2 = tokenType == TokenType.CurlyBracketRange;
        if (bl2) {
            IToken iToken8 = iTokenStream.next();
            AsmNodeList asmNodeList = new AsmNodeList(this.scopeNodeParser.parseAll(iToken8.getChildStream(), evaluationState));
            if (!bl) {
                return asmNodeList;
            }
            return new BracketScopeDirective(asmNodeList);
        }
        if (tokenType == TokenType.Not) {
            IToken iToken9;
            IToken iToken10 = iTokenStream.next();
            Object object = "!";
            if (tokenType2 == TokenType.Id) {
                object = "!" + iTokenStream.next().getStringValue();
            }
            if ((iToken9 = iTokenStream.expectType(TokenType.Colon, evaluationState)) == null) {
                return null;
            }
            SourceRange sourceRange = new SourceRange(iToken10.getSourceRange(), iToken9.getSourceRange());
            evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.label, sourceRange));
            return this.multiLabelNodeCreator.apply((String)object, sourceRange);
        }
        if ((tokenType == TokenType.Times || tokenType == TokenType.TimesEqual) && this.starParser != null) {
            IToken iToken11 = iTokenStream.next();
            evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.directive, iToken11.getSourceRange()));
            return this.starParser.parse(iToken11, iToken11.getSourceRange(), iTokenStream, evaluationState);
        }
        if (tokenType == TokenType.Semi) {
            iTokenStream.next();
            return null;
        }
        if (tokenType == TokenType.Colon && tokenType2 == TokenType.Id) {
            iTokenStream.next();
            NamespacePath namespacePath = NamespacePathParser.parse(iTokenStream, true, evaluationState);
            if (namespacePath == null) {
                return null;
            }
            tokenType = iTokenStream.peek().getType();
            if (tokenType == TokenType.ParanthesisRange) {
                return this.parseMacroExecution(namespacePath, iTokenStream, evaluationState);
            }
            return this.parsePseudocommandExecution(namespacePath, iTokenStream, evaluationState);
        }
        if (tokenType == TokenType.SubFileToken) {
            SubFileToken subFileToken = (SubFileToken)iTokenStream.next();
            File file = subFileToken.getFile();
            List<AsmNode> list = this.parseAll(subFileToken.getChildStream(), evaluationState);
            return new FileImportNode(new AsmNodeList(list), file.getParentFile(), subFileToken.getSourceRange());
        }
        return this.handleError(iTokenStream.next(), iTokenStream, evaluationState);
    }

    private AsmNode handleError(IToken iToken, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        evaluationState.diagnosticMgr.add(new AsmError("Invalid token", iToken.getSourceRange()));
        iTokenStream.getUntilSemiOrNl();
        return null;
    }

    private AsmNode parsePseudocommandExecution(NamespacePath namespacePath, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList;
        boolean bl = evaluationState.parameters.pseudoc3x;
        TokenStreamList tokenStreamList2 = bl ? iTokenStream.getUntilNlSkipWs() : iTokenStream.getUntilSemiOrNlSkipWs();
        ArrayList<_65xxArgumentExpr> arrayList = new ArrayList<_65xxArgumentExpr>();
        do {
            _65xxParsedArg _65xxParsedArg2;
            if ((_65xxParsedArg2 = _65xxArgParser.parse(tokenStreamList = bl ? tokenStreamList2.getUntilType(TokenType.Colon, TokenType.Semi) : tokenStreamList2.getUntilType(TokenType.Colon), evaluationState)) == null) {
                return null;
            }
            boolean bl2 = _65xxParsedArg2.type == _65xxArgType.unresolvedAbsolute;
            arrayList.add(new _65xxArgumentExpr(_65xxParsedArg2.type, _65xxParsedArg2.expr1, _65xxParsedArg2.expr2, bl2));
        } while (!tokenStreamList.getTerminatingToken().isEos());
        evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.pseudoCommandExecution, namespacePath.entityIdRange));
        return this.pseudoCommandNodeCreator.apply(namespacePath, arrayList);
    }

    private AsmNode parseMacroExecution(NamespacePath namespacePath, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        IToken iToken = tokenStreamList.next();
        TokenStreamList tokenStreamList2 = iToken.getChildStream();
        List<ExprNode> list = ExprParser.parseOptExprList(tokenStreamList2, evaluationState);
        if (list == null) {
            return null;
        }
        TokenUtil.addErrorOnExtraTokens(tokenStreamList, evaluationState);
        return this.macroExecNodeCreator.apply(namespacePath, list);
    }

    @Override
    public List<AsmNode> parseAll(ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        return this.parseAll(iTokenStream, evaluationState, true);
    }

    public List<AsmNode> parseAll(ITokenStream iTokenStream, EvaluationState evaluationState, boolean bl) throws IOException {
        ArrayList<AsmNode> arrayList = new ArrayList<AsmNode>();
        AsmNode asmNode = null;
        while (!iTokenStream.peek().isEos()) {
            AsmNode asmNode2 = this.parse(iTokenStream, evaluationState, bl);
            if (asmNode2 != null) {
                arrayList.add(asmNode2);
                if (asmNode != null && asmNode2 instanceof ILabelConnectorNode) {
                    ILabelConnectorNode iLabelConnectorNode = (ILabelConnectorNode)((Object)asmNode2);
                    iLabelConnectorNode.connectToLabel((ILabelNode)((Object)asmNode));
                }
            }
            asmNode = asmNode2 instanceof ILabelNode ? asmNode2 : null;
        }
        return arrayList;
    }
}

