/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.nonasm.util.functions.Func3;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class AlignTailParser
implements ITailParser<AsmNode> {
    private Func3<ExprNode, ExprNode, SourceRange, AsmNode> nodeCreator;

    public AlignTailParser(Func3<ExprNode, ExprNode, SourceRange, AsmNode> func3) {
        this.nodeCreator = func3;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        List<ExprNode> list = ExprParser.parseOptExprList(tokenStreamList, evaluationState);
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            evaluationState.diagnosticMgr.add(new AsmError("Missing page size argument", iToken.getSourceRange()));
            return null;
        }
        ExprNode exprNode = list.get(0);
        ExprNode exprNode2 = null;
        if (list.size() >= 2) {
            exprNode2 = list.get(1);
        }
        if (list.size() > 2) {
            evaluationState.diagnosticMgr.add(new AsmError("Align only takes two arguments.", iToken.getSourceRange()));
            return null;
        }
        return this.nodeCreator.apply(exprNode, exprNode2, sourceRange);
    }
}

