/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.nonasm.util.functions.Func5;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.IDirectiveParser;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class ForEachTailParser<NODE>
implements ITailParser<NODE> {
    private IDirectiveParser<NODE> subParser;
    private Func5<StringRangeList, List<ExprNode>, ExprNode, NODE, SourceRange, NODE> nodeCreator;

    public ForEachTailParser(IDirectiveParser<NODE> iDirectiveParser, Func5<StringRangeList, List<ExprNode>, ExprNode, NODE, SourceRange, NODE> func5) {
        this.nodeCreator = func5;
        this.subParser = iDirectiveParser;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        IToken iToken2 = iTokenStream.expectTypeSkipWs(TokenType.ParanthesisRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        NODE NODE = this.subParser.parse(iTokenStream, evaluationState);
        if (NODE == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Directive missing body", sourceRange));
            return null;
        }
        TokenStreamList tokenStreamList = iToken2.getChildStream();
        TokenStreamList tokenStreamList2 = tokenStreamList.getUntilIdSkipWsAndNl("in");
        if (!tokenStreamList2.getTerminatingToken().isId("in")) {
            SourceRange sourceRange2 = tokenStreamList2.getTerminatingToken().getSourceRange();
            evaluationState.diagnosticMgr.add(new AsmError("Expected 'in'", sourceRange2));
            return null;
        }
        StringRangeList stringRangeList = ExprParser.parseOptIdList(tokenStreamList2, evaluationState);
        TokenStreamList tokenStreamList3 = tokenStreamList.getUntilIdSkipWsAndNl("if");
        List<ExprNode> list = ExprParser.parseOptExprList(tokenStreamList3, evaluationState);
        ExprNode exprNode = null;
        if (tokenStreamList3.getTerminatingToken().isId("if")) {
            exprNode = ExprParser.parse(tokenStreamList, evaluationState);
        }
        if (stringRangeList == null || list == null) {
            return null;
        }
        return this.nodeCreator.apply(stringRangeList, list, exprNode, NODE, sourceRange);
    }
}

