/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kickass.nonasm.util.functions.Func4;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.mainparse.IDirectiveParser;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.misc.NamespacePathParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.asmnode.AsmNode;
import kickass.state.EvaluationState;
import kickass.state.namespace.NamespacePath;

public class MacroDefinitionTailParser
implements ITailParser<AsmNode> {
    private IDirectiveParser<AsmNode> bodyParser;
    private Func4<NamespacePath, StringRangeList, List<AsmNode>, SourceRange, AsmNode> nodeCreator;

    public MacroDefinitionTailParser(IDirectiveParser<AsmNode> iDirectiveParser, Func4<NamespacePath, StringRangeList, List<AsmNode>, SourceRange, AsmNode> func4) {
        this.nodeCreator = func4;
        this.bodyParser = iDirectiveParser;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        List<AsmNode> list;
        boolean bl;
        NamespacePath namespacePath = NamespacePathParser.parse(iTokenStream, true, evaluationState);
        if (namespacePath == null) {
            return null;
        }
        IToken iToken2 = iTokenStream.expectTypeSkipWsAndNl(TokenType.ParanthesisRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        StringRangeList stringRangeList = ExprParser.parseOptIdList(iToken2.getChildStream(), evaluationState);
        iTokenStream.skipWsAndNl();
        boolean bl2 = bl = iTokenStream.peek().getType() == TokenType.CurlyBracketRange;
        if (bl) {
            IToken iToken3 = iTokenStream.next();
            list = this.bodyParser.parseAll(iToken3.getChildStream(), evaluationState);
        } else {
            AsmNode asmNode = this.bodyParser.parse(iTokenStream, evaluationState);
            if (asmNode == null) {
                return null;
            }
            list = new ArrayList<AsmNode>();
            list.add(asmNode);
        }
        if (stringRangeList == null) {
            return null;
        }
        return this.nodeCreator.apply(namespacePath, stringRangeList, list, sourceRange);
    }
}

