/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.List;
import kickass.nonasm.util.functions.Func3;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.mainparse.IDirectiveParser;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.misc.NamespacePathParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;
import kickass.state.namespace.NamespacePath;

public class NamespaceTailParser<NODE>
implements ITailParser<NODE> {
    private IDirectiveParser<NODE> bodyParser;
    private Func3<NamespacePath, List<NODE>, SourceRange, NODE> nodeCreator;

    public NamespaceTailParser(IDirectiveParser<NODE> iDirectiveParser, Func3<NamespacePath, List<NODE>, SourceRange, NODE> func3) {
        this.nodeCreator = func3;
        this.bodyParser = iDirectiveParser;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        NamespacePath namespacePath = NamespacePathParser.parse(iTokenStream, false, evaluationState);
        if (namespacePath == null) {
            return null;
        }
        IToken iToken2 = iTokenStream.expectTypeSkipWsAndNl(TokenType.CurlyBracketRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        List<NODE> list = this.bodyParser.parseAll(iToken2.getChildStream(), evaluationState);
        return this.nodeCreator.apply(namespacePath, list, sourceRange);
    }
}

