/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.nonasm.util.functions.Func4;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.misc.NamespacePathParser;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;
import kickass.state.namespace.NamespacePath;

public class SegmentTailParser<NODE>
implements ITailParser<NODE> {
    private boolean isDefOnly;
    private Func4<NamespacePath, ExprNode, ParameterMap, SourceRange, NODE> nodeCreator;

    public SegmentTailParser(boolean bl, Func4<NamespacePath, ExprNode, ParameterMap, SourceRange, NODE> func4) {
        this.isDefOnly = bl;
        this.nodeCreator = func4;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        NamespacePath namespacePath = NamespacePathParser.parse(tokenStreamList, true, evaluationState);
        if (namespacePath == null) {
            return null;
        }
        ParameterMap parameterMap = null;
        tokenStreamList.skipWs();
        IToken iToken2 = tokenStreamList.peek();
        if (iToken2.getType() == TokenType.SquareBracketRange) {
            tokenStreamList.next();
            parameterMap = ExprParser.parseParametersMap(iToken2.getChildStream(), evaluationState, iToken2.getSourceRange());
            if (parameterMap == null) {
                return null;
            }
        }
        tokenStreamList.skipWs();
        IToken iToken3 = tokenStreamList.peek();
        ExprNode exprNode = null;
        if (!this.isDefOnly && !iToken3.isEos() && (exprNode = ExprParser.parse(tokenStreamList, evaluationState)) == null) {
            return null;
        }
        return this.nodeCreator.apply(namespacePath, exprNode, parameterMap, sourceRange);
    }
}

