/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.nonasm.util.functions.Func3;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.misc.NamespacePathParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.asmnode.AsmNode;
import kickass.state.EvaluationState;
import kickass.state.namespace.NamespacePath;

public class StructBodyParser
implements ITailParser<AsmNode> {
    private Func3<NamespacePath, StringRangeList, SourceRange, AsmNode> nodeCreator;

    public StructBodyParser(Func3<NamespacePath, StringRangeList, SourceRange, AsmNode> func3) {
        this.nodeCreator = func3;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        NamespacePath namespacePath = NamespacePathParser.parse(iTokenStream, true, evaluationState);
        if (namespacePath == null) {
            return null;
        }
        iTokenStream.skipWsAndNl();
        IToken iToken2 = iTokenStream.expectTypeSkipWs(TokenType.CurlyBracketRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        StringRangeList stringRangeList = ExprParser.parseOptIdList(iToken2.getChildStream(), evaluationState);
        if (stringRangeList == null) {
            return null;
        }
        return this.nodeCreator.apply(namespacePath, stringRangeList, sourceRange);
    }
}

