/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.misc;

import java.io.IOException;
import java.io.StringReader;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.baselang.BaseLangLexer;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.PeekTokenStream;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;
import kickass.state.namespace.NamespacePath;
import kickass.state.namespace.NamespacePathType;

public class NamespacePathParser {
    public static NamespacePath parse(String string, boolean bl, EvaluationState evaluationState, SourceRange sourceRange) {
        BaseLangLexer baseLangLexer = new BaseLangLexer(new StringReader(string));
        baseLangLexer.setFixedSourceRange(sourceRange);
        PeekTokenStream peekTokenStream = new PeekTokenStream(baseLangLexer);
        try {
            return NamespacePathParser.parse(peekTokenStream, bl, evaluationState);
        }
        catch (IOException iOException) {
            throw new ShouldNotBeHereException("IOExceptions should not occur on string input");
        }
    }

    public static NamespacePath parse(ITokenStream iTokenStream, boolean bl, EvaluationState evaluationState) throws IOException {
        boolean bl2;
        iTokenStream.skipWsAndNl();
        NamespacePath namespacePath = new NamespacePath();
        namespacePath.type = null;
        IToken iToken = iTokenStream.peek();
        namespacePath.noOfParentDots = 0;
        boolean bl3 = bl2 = iToken.getType() == TokenType.Dot;
        if (bl2) {
            namespacePath.type = NamespacePathType.ParentRelative;
            IToken iToken2 = iTokenStream.peek();
            IToken iToken3 = null;
            while (iTokenStream.peek().getType() == TokenType.Dot) {
                ++namespacePath.noOfParentDots;
                iToken3 = iTokenStream.next();
            }
            namespacePath.dotsRange = new SourceRange(iToken2.getSourceRange(), iToken3.getSourceRange());
            return NamespacePathParser.parsePathIds(namespacePath, bl, iTokenStream, evaluationState);
        }
        if (!iToken.expectId(evaluationState)) {
            return null;
        }
        if (iToken.getStringValue().startsWith("@")) {
            namespacePath.type = NamespacePathType.RootRelative;
            return NamespacePathParser.parsePathIds(namespacePath, bl, iTokenStream, evaluationState);
        }
        namespacePath.type = NamespacePathType.Relative;
        return NamespacePathParser.parsePathIds(namespacePath, bl, iTokenStream, evaluationState);
    }

    private static NamespacePath parsePathIds(NamespacePath namespacePath, boolean bl, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        IToken iToken = iTokenStream.peek();
        if (iToken.getType() != TokenType.Id) {
            return namespacePath;
        }
        IToken iToken2 = iTokenStream.next();
        String string = iToken2.getStringValue();
        SourceRange sourceRange = iToken2.getSourceRange();
        if (namespacePath.type == NamespacePathType.RootRelative) {
            string = string.substring(1);
        }
        while (iTokenStream.peek().getType() == TokenType.Dot) {
            namespacePath.pathIds.add(new Pair<String, SourceRange>(string, sourceRange));
            iTokenStream.next();
            iToken2 = iTokenStream.expectType(TokenType.Id, evaluationState);
            if (iToken2 == null) {
                return null;
            }
            string = iToken2.getStringValue();
            sourceRange = iToken2.getSourceRange();
        }
        if (!bl && string != null) {
            namespacePath.pathIds.add(new Pair<String, SourceRange>(string, sourceRange));
        }
        if (bl) {
            if (string == null) {
                evaluationState.diagnosticMgr.add(new AsmError("Missing id. Can't have empty namespace path.", iToken.getSourceRange()));
                return null;
            }
            namespacePath.entityId = string;
            namespacePath.entityIdRange = sourceRange;
        }
        return namespacePath;
    }
}

