/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.script.symbolstreams;

import java_cup.runtime.Symbol;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;

public class TokenToScriptSymbolConverter {
    private static int[] convTable = new int[TokenType.getNoOfTypes()];
    private static int[] convTable_DoubleSquareBracketRange;

    public static Symbol getSymbolValue(IToken iToken) {
        TokenType tokenType = iToken.getType();
        if (tokenType == TokenType.Id) {
            String string = iToken.getStringValue();
            if (string.equals("var")) {
                return new Symbol(50, iToken);
            }
            if (string.equals("const")) {
                return new Symbol(51, iToken);
            }
            if (string.equals("foreach")) {
                return new Symbol(54, iToken);
            }
            if (string.equals("in")) {
                return new Symbol(55, iToken);
            }
            if (string.equals("if")) {
                return new Symbol(56, iToken);
            }
            if (string.equals("groupby")) {
                return new Symbol(57, iToken);
            }
        }
        return new Symbol(convTable[tokenType.getIdNo()], iToken);
    }

    static {
        for (int i = 0; i < convTable.length; ++i) {
            TokenToScriptSymbolConverter.convTable[i] = 66;
        }
        TokenToScriptSymbolConverter.convTable[TokenType.Id.getIdNo()] = 60;
        TokenToScriptSymbolConverter.convTable[TokenType.LocalLabelId.getIdNo()] = 61;
        TokenToScriptSymbolConverter.convTable[TokenType.Null.getIdNo()] = 64;
        TokenToScriptSymbolConverter.convTable[TokenType.Boolean.getIdNo()] = 59;
        TokenToScriptSymbolConverter.convTable[TokenType.Number.getIdNo()] = 58;
        TokenToScriptSymbolConverter.convTable[TokenType.StringQuote.getIdNo()] = 62;
        TokenToScriptSymbolConverter.convTable[TokenType.CharQuote.getIdNo()] = 63;
        TokenToScriptSymbolConverter.convTable[TokenType.Assign.getIdNo()] = 11;
        TokenToScriptSymbolConverter.convTable[TokenType.Comma.getIdNo()] = 46;
        TokenToScriptSymbolConverter.convTable[TokenType.Semi.getIdNo()] = 47;
        TokenToScriptSymbolConverter.convTable[TokenType.GreaterEqual.getIdNo()] = 33;
        TokenToScriptSymbolConverter.convTable[TokenType.LessEqual.getIdNo()] = 32;
        TokenToScriptSymbolConverter.convTable[TokenType.Greater.getIdNo()] = 17;
        TokenToScriptSymbolConverter.convTable[TokenType.Less.getIdNo()] = 16;
        TokenToScriptSymbolConverter.convTable[TokenType.BitAnd.getIdNo()] = 22;
        TokenToScriptSymbolConverter.convTable[TokenType.BitOr.getIdNo()] = 23;
        TokenToScriptSymbolConverter.convTable[TokenType.BitXor.getIdNo()] = 24;
        TokenToScriptSymbolConverter.convTable[TokenType.BitNot.getIdNo()] = 25;
        TokenToScriptSymbolConverter.convTable[TokenType.ShiftLeft.getIdNo()] = 26;
        TokenToScriptSymbolConverter.convTable[TokenType.ShiftRight.getIdNo()] = 27;
        TokenToScriptSymbolConverter.convTable[TokenType.Plus.getIdNo()] = 12;
        TokenToScriptSymbolConverter.convTable[TokenType.Minus.getIdNo()] = 13;
        TokenToScriptSymbolConverter.convTable[TokenType.Times.getIdNo()] = 14;
        TokenToScriptSymbolConverter.convTable[TokenType.Divide.getIdNo()] = 15;
        TokenToScriptSymbolConverter.convTable[TokenType.NotEqual.getIdNo()] = 29;
        TokenToScriptSymbolConverter.convTable[TokenType.Equal.getIdNo()] = 28;
        TokenToScriptSymbolConverter.convTable[TokenType.And.getIdNo()] = 34;
        TokenToScriptSymbolConverter.convTable[TokenType.Or.getIdNo()] = 35;
        TokenToScriptSymbolConverter.convTable[TokenType.Not.getIdNo()] = 30;
        TokenToScriptSymbolConverter.convTable[TokenType.PlusPlus.getIdNo()] = 38;
        TokenToScriptSymbolConverter.convTable[TokenType.MinusMinus.getIdNo()] = 39;
        TokenToScriptSymbolConverter.convTable[TokenType.PlusEqual.getIdNo()] = 40;
        TokenToScriptSymbolConverter.convTable[TokenType.MinusEqual.getIdNo()] = 41;
        TokenToScriptSymbolConverter.convTable[TokenType.TimesEqual.getIdNo()] = 42;
        TokenToScriptSymbolConverter.convTable[TokenType.DivideEqual.getIdNo()] = 43;
        TokenToScriptSymbolConverter.convTable[TokenType.Dot.getIdNo()] = 31;
        TokenToScriptSymbolConverter.convTable[TokenType.Colon.getIdNo()] = 48;
        TokenToScriptSymbolConverter.convTable[TokenType.Questionmark.getIdNo()] = 49;
        TokenToScriptSymbolConverter.convTable[TokenType.LSBracket.getIdNo()] = 18;
        TokenToScriptSymbolConverter.convTable[TokenType.RSBracket.getIdNo()] = 19;
        TokenToScriptSymbolConverter.convTable[TokenType.LParan.getIdNo()] = 44;
        TokenToScriptSymbolConverter.convTable[TokenType.RParan.getIdNo()] = 45;
        TokenToScriptSymbolConverter.convTable[TokenType.LCBracket.getIdNo()] = 20;
        TokenToScriptSymbolConverter.convTable[TokenType.RCBracket.getIdNo()] = 21;
        TokenToScriptSymbolConverter.convTable[TokenType.Eos.getIdNo()] = 0;
        TokenToScriptSymbolConverter.convTable[TokenType.HashRange.getIdNo()] = 52;
        TokenToScriptSymbolConverter.convTable[TokenType.LambdaArrow.getIdNo()] = 53;
    }
}

