/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.segments.SegmentMemoryBlock;

public class AlignDirective
extends AsmDirective {
    private ExprNode pageSizeExpr;
    private ExprNode trailSizeExpr;
    private SegmentMemoryBlock.Entry memEntry;

    public AlignDirective(ExprNode exprNode, ExprNode exprNode2, SourceRange sourceRange) {
        super(sourceRange);
        this.pageSizeExpr = exprNode;
        this.trailSizeExpr = exprNode2;
    }

    @Override
    public AsmNode copy() {
        return new AlignDirective(this.pageSizeExpr, this.trailSizeExpr, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.pageSizeExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        int n;
        Value value;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        if (this.memEntry == null) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
        }
        if ((value = this.pageSizeExpr.evaluate(evaluationState)).isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n2 = value.getInt(this.range);
        if (n2 <= 0) {
            throw new AsmErrorException("Page size must be positive.", this.range);
        }
        int n3 = -1;
        if (this.trailSizeExpr != null) {
            Value value2 = this.trailSizeExpr.evaluate(evaluationState);
            if (value2.isInvalid()) {
                return this.invalidatePcAndReturnThis(evaluationState);
            }
            n3 = value2.getInt(this.range);
            if (n3 <= 0) {
                throw new AsmErrorException("Trail size must be positive.", this.range);
            }
        }
        if ((n = evaluationState.segmentMgr.getMemoryPosition()) < 0) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n4 = n2 - n % n2;
        if (n4 == n2) {
            n4 = 0;
        }
        if (n3 > 0) {
            boolean bl;
            int n5 = n / n2;
            int n6 = (n + n3 - 1) / n2;
            boolean bl2 = bl = n5 == n6;
            if (bl) {
                n4 = 0;
            }
        }
        this.memEntry.fillEntry(new byte[n4], this.range);
        evaluationState.segmentMgr.increaseMemoryPosition(n4);
        if (evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

