/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.namespace.NamespacePath;
import kickass.state.segments.Segment;

public class AssertSegmentDirective
extends Directive {
    private ExprNode msgExpr;
    private NamespacePath resultNsPath;
    private NamespacePath expectedNsPath;
    private Segment expectedSegment;
    private Segment resultSegment;

    public AssertSegmentDirective(ExprNode exprNode, NamespacePath namespacePath, NamespacePath namespacePath2, SourceRange sourceRange) {
        super(sourceRange);
        this.msgExpr = exprNode;
        this.resultNsPath = namespacePath;
        this.expectedNsPath = namespacePath2;
    }

    @Override
    public AsmNode copy() {
        return new AssertSegmentDirective(this.msgExpr, this.resultNsPath, this.expectedNsPath, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.expectedSegment = evaluationState.segmentMgr.resolveSegment(this.expectedNsPath, evaluationState);
        this.resultSegment = evaluationState.segmentMgr.resolveSegment(this.resultNsPath, evaluationState);
        this.msgExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.msgExpr.evaluate(evaluationState);
        if (value.isInvalid() || evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        if (!this.expectedSegment.isReadyToFinalize(evaluationState) || !this.resultSegment.isReadyToFinalize(evaluationState)) {
            return this;
        }
        this.expectedSegment.finalize(evaluationState);
        this.resultSegment.finalize(evaluationState);
        boolean bl = this.expectedSegment.flattenAreEqual(this.resultSegment);
        String string = bl ? value.getString(this.range) + " -- OK." : value.getString(this.range) + " -- FAILED!";
        evaluationState.sideeffectMgr.addTextOutput(string);
        evaluationState.assertMgr.madeAssert(!bl);
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

