/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.segments.SegmentMemoryBlock;

public class DataBlockDirective
extends AsmDirective {
    private int datasize;
    private List<ExprNode> datalist;
    private SegmentMemoryBlock.Entry memEntry;

    public DataBlockDirective(int n, List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.datasize = n;
        this.datalist = list;
    }

    @Override
    public AsmNode copy() {
        return new DataBlockDirective(this.datasize, this.datalist, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        for (ExprNode exprNode : this.datalist) {
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        if (this.memEntry == null) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
        }
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        byte[] byArray = new byte[this.datasize * this.datalist.size()];
        this.memEntry.setNoOfBytes(byArray.length);
        int n = 0;
        boolean bl = false;
        for (ExprNode exprNode : this.datalist) {
            Value value = exprNode.evaluate(evaluationState);
            if (value.isInvalid()) {
                n += this.datasize;
                bl = true;
                continue;
            }
            long l = value.getLong(this.range);
            for (int i = 0; i < this.datasize; ++i) {
                byArray[n++] = (byte)(l & 0xFFL);
                l >>= 8;
            }
        }
        evaluationState.segmentMgr.increaseMemoryPosition(this.datasize * this.datalist.size());
        if (bl || evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        this.memEntry.fillEntry(byArray, this.range);
        evaluationState.setMadeMetaProgress();
        return SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

