/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.plugins.interf.diskwriter.DiskWriterDefinition;
import kickass.plugins.interf.diskwriter.IDiskWriter;
import kickass.state.EvaluationState;
import kickass.state.c64output.C64OutputManager;
import kickass.state.c64output.D64Disk;
import kickass.state.c64output.D64File;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentParser;

public class DiskDirective
extends Directive {
    private static int diskfileCount = 0;
    private String writerName;
    private IDiskWriter writer;
    private ParameterMap diskParameters;
    private List<ParameterMap> fileParameters;

    public DiskDirective(String string, ParameterMap parameterMap, List<ParameterMap> list, SourceRange sourceRange) {
        super(sourceRange);
        this.writerName = string;
        this.diskParameters = parameterMap;
        this.fileParameters = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        if (this.writerName == null) {
            this.writer = C64OutputManager.defaultDiskWriter;
        } else {
            this.writer = evaluationState.c64OutputMgr.getDiskWriter(this.writerName);
            if (this.writer == null) {
                evaluationState.diagnosticMgr.add(new AsmError("Unknown disk writer '" + this.writerName + "'", this.range));
                return EmptyOutput.instance;
            }
        }
        DiskWriterDefinition diskWriterDefinition = this.writer.getDefinition();
        HashSet<String> hashSet = new HashSet<String>(diskWriterDefinition.getAllFileParameters());
        hashSet.addAll(SegmentParser.combiParameters);
        this.diskParameters.addErrorIfNotExist(diskWriterDefinition.getNonOptionalDiskParameters(), evaluationState);
        this.diskParameters.addErrorsForUnknownParameters(diskWriterDefinition.getAllDiskParameters(), evaluationState);
        this.diskParameters.executePrepass(evaluationState);
        for (ParameterMap parameterMap : this.fileParameters) {
            SegmentParser.addErrorIfNotExists(parameterMap, diskWriterDefinition.getNonOptionalFileParameters(), true, evaluationState);
            SegmentParser.addErrorForUnknownParameters(parameterMap, hashSet, true, evaluationState);
            parameterMap.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        boolean bl = this.diskParameters.evaluateAllParameters(evaluationState);
        for (ParameterMap object2 : this.fileParameters) {
            boolean bl2 = object2.evaluateAllParameters(evaluationState);
            bl |= bl2;
        }
        if (bl) {
            return this;
        }
        ArrayList arrayList = new ArrayList();
        for (ParameterMap parameterMap : this.fileParameters) {
            Segment segment = new Segment("!system.!segments.<<diskfile-" + diskfileCount++ + ">>", this.range);
            SegmentParser.fillCombiSegment(segment, parameterMap, evaluationState);
            segment.initPass();
            evaluationState.segmentMgr.addSegment(segment, evaluationState);
            D64File d64File = new D64File(segment, parameterMap);
            arrayList.add(d64File);
        }
        D64Disk d64Disk = new D64Disk(this.writer, this.diskParameters, arrayList, this.range);
        evaluationState.c64OutputMgr.addD64Disk(d64Disk);
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

