/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.ArrayList;
import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelConnectorNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.metanodes.AsmNodeList;
import kickass.pass.asmnode.metanodes.ScopeAndSymbolPageNode;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.valueholder.VariableValueHolder;
import kickass.pass.values.LabelValue;
import kickass.pass.values.NullValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.ScopeArrayValue;
import kickass.pass.values.ScopeValue;
import kickass.pass.values.Value;
import kickass.pass.values.valueiterator.IValueIterator;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.scope.symboltable.SymbolTable;

public class ForEachDirective
extends Directive
implements ILabelConnectorNode {
    private StringRange enumerationId;
    private StringRangeList varIds;
    private List<ExprNode> iterExprs;
    private ExprNode ifExpr;
    private AsmNode body;
    private String labelId;
    private SymbolScope countVarScope;
    private SymbolScope innerScope;
    private ISymbolPageIdx labelPageIdx;
    private ISymbolPageIdx enumeratorSymbolPageIdx;
    private ISymbolPageIdx[] iterVarSymbolPageIdxs;

    public ForEachDirective(StringRangeList stringRangeList, List<ExprNode> list, ExprNode exprNode, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.enumerationId = null;
        if (stringRangeList.size() > list.size()) {
            this.enumerationId = (StringRange)stringRangeList.get(0);
            stringRangeList = stringRangeList.subList(1, stringRangeList.size());
        }
        this.varIds = stringRangeList;
        this.iterExprs = list;
        this.ifExpr = exprNode;
        this.body = asmNode;
    }

    private ForEachDirective(ForEachDirective forEachDirective) {
        super(forEachDirective.range);
        this.enumerationId = forEachDirective.enumerationId;
        this.varIds = forEachDirective.varIds;
        this.iterExprs = forEachDirective.iterExprs;
        this.ifExpr = forEachDirective.ifExpr;
        this.labelId = forEachDirective.labelId;
        this.body = forEachDirective.body.copy();
        this.countVarScope = forEachDirective.countVarScope;
        this.innerScope = forEachDirective.innerScope;
        this.iterVarSymbolPageIdxs = forEachDirective.iterVarSymbolPageIdxs;
        this.enumeratorSymbolPageIdx = forEachDirective.enumeratorSymbolPageIdx;
        this.labelPageIdx = forEachDirective.labelPageIdx;
    }

    @Override
    public boolean connectToLabel(ILabelNode iLabelNode) {
        this.labelId = iLabelNode.getName();
        return true;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public AsmNode copy() {
        return new ForEachDirective(this);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        if (this.iterExprs.size() == 0) {
            evaluationState.diagnosticMgr.add(new AsmError("You must supply an iterator", this.range));
        } else if (this.varIds.size() != this.iterExprs.size()) {
            evaluationState.diagnosticMgr.add(new AsmError("Number of itererators does not match the number of variables", this.iterExprs.getLast().getSourceRange()));
        }
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        this.countVarScope = new SymbolScope(symbolScope, null);
        this.innerScope = new SymbolScope(this.countVarScope, new SymbolTable());
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope);
        if (this.enumerationId != null) {
            this.enumeratorSymbolPageIdx = this.countVarScope.defineErrorIfExist(this.enumerationId.string, VariableValueHolder.initializer, evaluationState, "Symbol already defined", this.enumerationId.range);
        }
        int n = 0;
        this.iterVarSymbolPageIdxs = new ISymbolPageIdx[this.varIds.size()];
        for (StringRange stringRange : this.varIds) {
            this.iterVarSymbolPageIdxs[n++] = this.countVarScope.defineErrorIfExist(stringRange.string, VariableValueHolder.initializer, evaluationState, "Symbol already defined", stringRange.range);
        }
        evaluationState.scopeMgr.setCurrentScope(this.innerScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
        if (this.labelId != null) {
            this.labelPageIdx = evaluationState.scopeMgr.resolveSymbol(this.labelId);
            this.labelPageIdx.replaceInitializer(LabelValue.getInitializer(evaluationState, () -> new ScopeArrayValue(this.innerScope)));
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        for (ExprNode exprNode : this.iterExprs) {
            exprNode.executePrepass(evaluationState);
        }
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope);
        if (this.enumeratorSymbolPageIdx != null) {
            this.enumeratorSymbolPageIdx.setStatus(SymbolStatus.defined);
        }
        for (ISymbolPageIdx iSymbolPageIdx : this.iterVarSymbolPageIdxs) {
            iSymbolPageIdx.setStatus(SymbolStatus.defined);
        }
        if (this.ifExpr != null) {
            this.ifExpr.executePrepass(evaluationState);
        }
        evaluationState.scopeMgr.setCurrentScope(this.innerScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope.getParent());
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        int n;
        Object object;
        ArrayList<AsmNode> arrayList = new ArrayList<AsmNode>();
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        ScopeArrayValue scopeArrayValue = null;
        if (this.labelPageIdx != null) {
            object = (LabelValue)this.labelPageIdx.getValueHolder().getWithoutSideeffect();
            scopeArrayValue = (ScopeArrayValue)((LabelValue)object).getConnectedValue();
        }
        object = new IValueIterator[this.iterExprs.size()];
        for (n = 0; n < this.iterExprs.size(); ++n) {
            Value value = this.iterExprs.get(n).evaluate(evaluationState);
            object[n] = value.getIterator(this.range);
        }
        n = 0;
        while (true) {
            block12: {
                IValueHolder[] iValueHolderArray;
                Object object2;
                block11: {
                    if (this.enumerationId != null) {
                        IValueHolder iValueHolder = this.enumeratorSymbolPageIdx.getValueHolder();
                        iValueHolder.set(new NumberValue(n), evaluationState, this.range);
                    }
                    boolean bl = false;
                    int n2 = 0;
                    for (int i = 0; i < this.iterExprs.size(); ++i) {
                        object2 = this.iterExprs.get(i).getSourceRange();
                        Object object3 = object[i];
                        boolean bl2 = object3.hasNext();
                        NullValue nullValue = bl2 ? object3.next((SourceRange)object2) : NullValue.instance;
                        bl |= bl2;
                        IValueHolder iValueHolder = this.iterVarSymbolPageIdxs[n2++].getValueHolder();
                        iValueHolder.set(nullValue, evaluationState, this.range);
                    }
                    if (!bl) break;
                    if (this.ifExpr == null) break block11;
                    iValueHolderArray = this.ifExpr.evaluate(evaluationState);
                    if (iValueHolderArray.isInvalid()) {
                        throw new AsmErrorException("Can't evaluate filter in first pass", this.range);
                    }
                    if (!iValueHolderArray.getBoolean(this.range)) break block12;
                }
                arrayList.add(new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput()));
                evaluationState.sideeffectMgr.clearFunctionSideOutput();
                iValueHolderArray = this.innerScope.getSymbolTable().createPage();
                object2 = new ScopeAndSymbolPageNode(this.body.copy(), this.innerScope, iValueHolderArray);
                object2 = ((AsmNode)object2).executePass(evaluationState);
                arrayList.add((AsmNode)object2);
                if (scopeArrayValue != null) {
                    scopeArrayValue.addScopeValue(new ScopeValue(this.innerScope, iValueHolderArray));
                }
                evaluationState.sideeffectMgr.clearFunctionSideOutput();
            }
            ++n;
        }
        arrayList.add(new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput()));
        if (scopeArrayValue != null) {
            scopeArrayValue.setLoopExecuted();
        }
        return new AsmNodeList(arrayList);
    }
}

