/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.directives.UserFunction;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.function.Function;
import kickass.pass.function.functionselector.IFunctionSelector;
import kickass.pass.function.functionselector.MultiFunctionSelector;
import kickass.pass.functionnode.FunctionNode;
import kickass.state.EvaluationState;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;
import kickass.state.scope.EntityScope;

public class FunctionDeclarationDirective
extends AsmDirective {
    private NamespacePath nspath;
    private StringRangeList argumentNames;
    private List<FunctionNode> body;
    private UserFunction function;

    public FunctionDeclarationDirective(NamespacePath namespacePath, StringRangeList stringRangeList, List<FunctionNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.nspath = namespacePath;
        this.argumentNames = stringRangeList;
        this.body = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl;
        boolean bl2;
        Namespace namespace = evaluationState.namespaceMgr.resolveNSPathForDefinition(this.nspath, evaluationState);
        if (namespace == null) {
            return EmptyOutput.instance;
        }
        String string = this.nspath.entityId;
        EntityScope<IFunctionSelector> entityScope = namespace.getFunctions();
        IFunctionSelector iFunctionSelector = entityScope.getLocalDefinedEntities().get(string);
        if (iFunctionSelector == null) {
            iFunctionSelector = new MultiFunctionSelector(string, new Function[0]);
            entityScope.put(string, iFunctionSelector);
        }
        boolean bl3 = bl2 = evaluationState.namespaceMgr.getCurrentNamespace().getScope() == evaluationState.scopeMgr.getCurrentScope();
        if (!bl2) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't define a function here. Define it in the direct scope of the current namespace, not inside constructs like {}, .if, .for, etc.", this.range));
            return EmptyOutput.instance;
        }
        this.function = new UserFunction(string, this.argumentNames, this.body, evaluationState.namespaceMgr.getCurrentNamespace(), this.range);
        boolean bl4 = bl = !iFunctionSelector.addFunction(this.function);
        if (bl) {
            evaluationState.diagnosticMgr.add(new AsmError("The function '" + string + "' is already defined.", this.range));
        }
        this.function.registerMetaDefinitions(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.function.executePrepass(evaluationState);
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }
}

