/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.io.InputStream;
import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.segments.SegmentMemoryBlock;

public class ImportBinaryDirective
extends AsmDirective {
    private boolean isC64File;
    private List<ExprNode> argumentExprs;
    private SegmentMemoryBlock.Entry memEntry;

    public ImportBinaryDirective(boolean bl, List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.isC64File = bl;
        this.argumentExprs = list;
    }

    @Override
    public Directive copy() {
        return new ImportBinaryDirective(this.isC64File, this.argumentExprs, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        if (this.argumentExprs.size() < 1 || 3 < this.argumentExprs.size()) {
            evaluationState.diagnosticMgr.add(new AsmError("Invalid number of arguments.", this.range));
            return EmptyOutput.instance;
        }
        for (ExprNode exprNode : this.argumentExprs) {
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        byte[] byArray;
        int n;
        Object object;
        Object object2;
        if (this.memEntry == null) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
        }
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.argumentExprs.get(0).evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmErrorException("Must be able to solve filename during first pass", this.range);
        }
        String string = value.getString(this.range);
        Integer n2 = null;
        if (this.argumentExprs.size() >= 2) {
            object2 = this.argumentExprs.get(1).evaluate(evaluationState);
            if (((Value)object2).isInvalid()) {
                throw new AsmErrorException("Must be able to solve offset argument during first pass", this.range);
            }
            n2 = ((Value)object2).getInt(this.range);
            if (n2 < 0) {
                throw new AsmErrorException("Offset can't be negative", this.range);
            }
        }
        object2 = null;
        if (this.argumentExprs.size() >= 3) {
            object = this.argumentExprs.get(2).evaluate(evaluationState);
            if (((Value)object).isInvalid()) {
                throw new AsmErrorException("Must be able to solve length argument during first pass", this.range);
            }
            object2 = ((Value)object).getInt(this.range);
            if ((Integer)object2 < 0) {
                throw new AsmErrorException("Length can't be negative", this.range);
            }
        }
        object = evaluationState.fileMgr.openFileOrFail(string, false, this.range);
        int n3 = 0;
        try {
            int n4 = 2;
            n = ((InputStream)object).available();
            if (n2 != null) {
                n = Math.max(0, n - n2);
                n4 = Math.max(n4, n2);
            }
            int n5 = object2 == null ? n : Math.min(n, (Integer)object2);
            n4 = Math.max(n4, n5);
            byArray = new byte[n4];
            if (this.isC64File) {
                ((InputStream)object).read(byArray, 0, 2);
            }
            if (n2 != null) {
                ((InputStream)object).read(byArray, 0, n2);
            }
            n3 = ((InputStream)object).read(byArray, 0, n5);
        }
        catch (Exception exception) {
            throw new AsmErrorException("Can't read file: " + string, this.range);
        }
        finally {
            try {
                ((InputStream)object).close();
            }
            catch (Exception exception) {}
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (object2 != null && n3 < (Integer)object2) {
            throw new AsmErrorException("File is too short for the desired length", this.range);
        }
        byte[] byArray2 = new byte[n3];
        for (n = 0; n < n3; ++n) {
            byArray2[n] = byArray[n];
        }
        evaluationState.segmentMgr.increaseMemoryPosition(byArray2.length);
        this.memEntry.fillEntry(byArray2, this.range);
        return SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

