/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.valueholder.VariableValueHolder;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.segments.SegmentMemoryBlock;

public class IndexFillDirective
extends AsmDirective {
    private int dataSize = 1;
    private ExprNode sizeExpr;
    private List<ExprNode> fillExprs;
    private SymbolScope innerScope;
    private ISymbolPageIdx iSymbolPageIdx;
    private SegmentMemoryBlock.Entry memEntry;

    public IndexFillDirective(ExprNode exprNode, List<ExprNode> list, SourceRange sourceRange, int n) {
        super(sourceRange);
        this.dataSize = n;
        this.sizeExpr = exprNode;
        this.fillExprs = list;
    }

    private IndexFillDirective(IndexFillDirective indexFillDirective) {
        super(indexFillDirective.range);
        this.dataSize = indexFillDirective.dataSize;
        this.sizeExpr = indexFillDirective.sizeExpr;
        this.fillExprs = indexFillDirective.fillExprs;
        this.innerScope = indexFillDirective.innerScope;
        this.iSymbolPageIdx = indexFillDirective.iSymbolPageIdx;
    }

    @Override
    public AsmNode copy() {
        return new IndexFillDirective(this);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        if (this.fillExprs.size() == 0) {
            evaluationState.diagnosticMgr.add(new AsmError("You must supply at lead one fill expression", this.range));
            return EmptyOutput.instance;
        }
        this.innerScope = new SymbolScope(evaluationState.scopeMgr.getCurrentScope(), null);
        this.iSymbolPageIdx = this.innerScope.define("i", VariableValueHolder.initializer);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.sizeExpr.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(this.innerScope);
        this.iSymbolPageIdx.setStatus(SymbolStatus.defined);
        for (ExprNode exprNode : this.fillExprs) {
            exprNode.executePrepass(evaluationState);
        }
        evaluationState.scopeMgr.setCurrentScope(this.innerScope.getParent());
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        int n;
        Value value;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        if (this.memEntry == null) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
        }
        if ((value = this.sizeExpr.evaluate(evaluationState)).isInvalid()) {
            throw new AsmErrorException("You must be able to determine the size argument en first pass", this.range);
        }
        int n2 = value.getInt(this.range);
        if (n2 < 0) {
            throw new AsmErrorException("The size of a fill directive can't be negative. Size=" + n2, this.range);
        }
        int n3 = n2 * this.fillExprs.size() * this.dataSize;
        this.memEntry.setNoOfBytes(n3);
        boolean bl = false;
        IValueHolder iValueHolder = this.iSymbolPageIdx.getValueHolder();
        byte[] byArray = new byte[n3];
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            iValueHolder.setWithoutSideEffect(new NumberValue(n));
            for (int i = 0; i < this.fillExprs.size(); ++i) {
                int n5;
                ExprNode exprNode = this.fillExprs.get(i);
                Value value2 = exprNode.evaluate(evaluationState);
                if (value2.isInvalid()) {
                    bl = true;
                    n5 = 0;
                } else {
                    n5 = value2.getInt(this.range);
                }
                for (int j = 0; j < this.dataSize; ++j) {
                    byArray[n4++] = (byte)(n5 & 0xFF);
                    n5 >>= 8;
                }
            }
        }
        evaluationState.segmentMgr.increaseMemoryPosition(n3);
        if (!bl) {
            this.memEntry.fillEntry(byArray, this.range);
        }
        n = bl || evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation() ? 1 : 0;
        return n != 0 ? this : SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

