/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.ArrayList;
import java.util.Iterator;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.pass.values.valueiterator.IValueIterator;
import kickass.state.EvaluationState;
import kickass.state.segments.SegmentMemoryBlock;

public class IterFillDirective
extends AsmDirective {
    private int dataSize = 1;
    private ExprNode iterExpr;
    private SegmentMemoryBlock.Entry memEntry;

    public IterFillDirective(ExprNode exprNode, SourceRange sourceRange, int n) {
        super(sourceRange);
        this.dataSize = n;
        this.iterExpr = exprNode;
    }

    private IterFillDirective(IterFillDirective iterFillDirective) {
        super(iterFillDirective.range);
        this.dataSize = iterFillDirective.dataSize;
        this.iterExpr = iterFillDirective.iterExpr;
    }

    @Override
    public AsmNode copy() {
        return new IterFillDirective(this);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.iterExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.iterExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmErrorException("The iteretor expression don't give a valid value in first pass.", this.range);
        }
        IValueIterator iValueIterator = value.getIterator(this.range);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        boolean bl = false;
        while (iValueIterator.hasNext()) {
            Value value2 = iValueIterator.next(this.iterExpr.getSourceRange());
            if (value2.isInvalid()) {
                bl = true;
                arrayList.add(0L);
                continue;
            }
            arrayList.add(value2.getLong(this.range));
        }
        int n = arrayList.size() * this.dataSize;
        if (this.memEntry == null) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
            this.memEntry.setNoOfBytes(n);
        }
        evaluationState.segmentMgr.increaseMemoryPosition(n);
        if (!bl) {
            byte[] byArray = new byte[n];
            int n2 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                for (int i = 0; i < this.dataSize; ++i) {
                    byArray[n2++] = (byte)(l & 0xFFL);
                    l >>= 8;
                }
            }
            this.memEntry.fillEntry(byArray, this.range);
        }
        boolean bl2 = bl || evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        return bl2 ? this : SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

