/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.LabelValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.ResolvedSymbol;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;

public class LabelAssignmentDirective
extends AsmDirective
implements ILabelNode {
    private String name;
    private ExprNode valueExpr;
    private ISymbolPageIdx symbolPageIdx;

    public LabelAssignmentDirective(String string, ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.valueExpr = exprNode;
    }

    private LabelAssignmentDirective(LabelAssignmentDirective labelAssignmentDirective) {
        super(labelAssignmentDirective.range);
        this.name = labelAssignmentDirective.name;
        this.valueExpr = labelAssignmentDirective.valueExpr;
        this.symbolPageIdx = labelAssignmentDirective.symbolPageIdx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AsmNode copy() {
        return new LabelAssignmentDirective(this);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl = this.name.startsWith("@");
        String string = bl ? this.name.substring(1) : this.name;
        SymbolScope symbolScope = evaluationState.scopeMgr.getRootOrCurrentScope(bl);
        if (symbolScope.isDefined(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("The symbol '" + string + "' is already defined", this.range));
            return this;
        }
        this.symbolPageIdx = symbolScope.define(string, LabelValue.getInitializer(evaluationState));
        this.symbolPageIdx.setStatus(SymbolStatus.defined);
        this.symbolPageIdx.setIsScopeExposed(true);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.valueExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        LabelValue labelValue = (LabelValue)this.symbolPageIdx.getValueHolder().getWithoutSideeffect();
        labelValue.resolveSegment(evaluationState.segmentMgr.getCurrentSegment().getBank());
        Value value = this.valueExpr.evaluate(evaluationState);
        if (value.isInvalidOrInvalidContent()) {
            return this;
        }
        if (!value.hasDouble()) {
            throw new AsmErrorException("The value of a label is expected to be a number value. This expression returns a value of type '" + value.getType() + "'", this.range);
        }
        labelValue.resolveLabel(value);
        evaluationState.scopeMgr.addResolvedSymbol(new ResolvedSymbol(this.name, value.getInt(this.range), evaluationState.segmentMgr.getCurrentSegment(), this.range));
        evaluationState.setMadeMetaProgress();
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }

    @Override
    public String toString() {
        return "Label(" + this.name + ")";
    }
}

