/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.diagnostics.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.values.LabelValue;
import kickass.pass.values.NumberValue;
import kickass.state.EvaluationState;
import kickass.state.scope.ResolvedSymbol;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;

public class LabelDirective
extends AsmDirective
implements ILabelNode {
    private String name;
    private ISymbolPageIdx symbolIdx;

    public LabelDirective(String string, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
    }

    private LabelDirective(LabelDirective labelDirective) {
        super(labelDirective.range);
        this.name = labelDirective.name;
        this.symbolIdx = labelDirective.symbolIdx;
    }

    @Override
    public AsmNode copy() {
        return new LabelDirective(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl = this.name.startsWith("@");
        String string = bl ? this.name.substring(1) : this.name;
        SymbolScope symbolScope = evaluationState.scopeMgr.getRootOrCurrentScope(bl);
        if (symbolScope.isDefined(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("The symbol '" + this.name + "' is already defined", this.range));
            return this;
        }
        this.symbolIdx = symbolScope.define(string, LabelValue.getInitializer(evaluationState));
        this.symbolIdx.setStatus(SymbolStatus.defined);
        this.symbolIdx.setIsScopeExposed(true);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        LabelValue labelValue = (LabelValue)this.symbolIdx.getValueHolder().getWithoutSideeffect();
        labelValue.resolveSegment(evaluationState.segmentMgr.getCurrentSegment().getBank());
        int n = evaluationState.segmentMgr.getMemoryPosition();
        if (n < 0) {
            return this;
        }
        NumberValue numberValue = new NumberValue(n);
        labelValue.resolveLabel(numberValue);
        evaluationState.scopeMgr.addResolvedSymbol(new ResolvedSymbol(this.name, n, evaluationState.segmentMgr.getCurrentSegment(), this.range));
        evaluationState.setMadeMetaProgress();
        return EmptyOutput.instance;
    }

    @Override
    public String toString() {
        return "Label(" + this.name + ")";
    }
}

