/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.Collections;
import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmException;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.metanodes.AsmNodeList;
import kickass.pass.asmnode.metanodes.MacroDefinitionRootNode;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.state.EvaluationState;
import kickass.state.ScopePosition;
import kickass.state.namespace.AnyMacro;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;
import kickass.state.scope.EntityScope;

public class MacroDefinition
extends AsmDirective {
    private NamespacePath nspath;
    private StringRangeList argNames;
    private List<AsmNode> body;
    private MacroDefinitionRootNode rootNode;

    public MacroDefinition(NamespacePath namespacePath, StringRangeList stringRangeList, List<AsmNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.nspath = namespacePath;
        this.argNames = stringRangeList;
        this.body = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl;
        boolean bl2 = bl = evaluationState.namespaceMgr.getCurrentNamespace().getScope() == evaluationState.scopeMgr.getCurrentScope();
        if (!bl) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't define a macro here. Define it in the direct scope of the current namespace, not inside constructs like {}, .if, .for etc.", this.range));
            return EmptyOutput.instance;
        }
        Namespace namespace = evaluationState.namespaceMgr.resolveNSPathForDefinition(this.nspath, evaluationState);
        if (namespace == null) {
            return EmptyOutput.instance;
        }
        EntityScope<AnyMacro> entityScope = namespace.getMacros();
        String string = this.nspath.entityId;
        if (entityScope.getLocalDefinedEntities().containsKey(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("The macro '" + string + "'  is already defined", this.range));
        }
        this.rootNode = new MacroDefinitionRootNode(this.argNames, Collections.emptyList(), new AsmNodeList(this.body), evaluationState.namespaceMgr.getCurrentNamespace(), ScopePosition.inMacro, this.range);
        entityScope.put(string, new AnyMacro(this.rootNode));
        this.rootNode.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.rootNode.executePrepass(evaluationState);
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) throws AsmException {
        throw new ShouldNotBeHereException();
    }
}

