/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.exceptions.AsmException;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelConnectorNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.metanodes.MacroDefinitionRootNode;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.LabelValue;
import kickass.pass.values.ScopeValue;
import kickass.pass.values.Value;
import kickass.plugins.impl.PluginEngine;
import kickass.plugins.impl.PluginValue;
import kickass.plugins.interf.general.IValue;
import kickass.plugins.interf.macro.IMacro;
import kickass.state.EvaluationState;
import kickass.state.namespace.AnyMacro;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.segments.SegmentMemoryBlock;

public class MacroExecution
extends AsmDirective
implements ILabelConnectorNode {
    private NamespacePath nspath;
    private List<ExprNode> argumentExprs;
    private String labelId;
    private List<Pair<String, SourceRange>> scopeIds;
    private ISymbolPageIdx labelPageIdx;
    MacroDefinitionRootNode macro;

    public MacroExecution(NamespacePath namespacePath, List<ExprNode> list) {
        super(namespacePath.entityIdRange);
        this.nspath = namespacePath;
        this.argumentExprs = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public boolean connectToLabel(ILabelNode iLabelNode) {
        this.labelId = iLabelNode.getName();
        return true;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) throws AsmException {
        for (ExprNode object2 : this.argumentExprs) {
            object2.executePrepass(evaluationState);
        }
        String string = this.nspath.entityId;
        Namespace namespace = evaluationState.namespaceMgr.resolveNSPathForExtraction(this.nspath, evaluationState);
        if (namespace == null) {
            return EmptyOutput.instance;
        }
        AnyMacro anyMacro = namespace.getMacros().get(string);
        if (anyMacro == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Macro command '" + (String)string + "' not defined", this.range));
            return EmptyOutput.instance;
        }
        if (anyMacro.user != null) {
            return this.preParseStandardMacro(evaluationState, anyMacro.user);
        }
        if (anyMacro.plugin != null) {
            return new PluginMacroExecution(anyMacro.plugin, this.argumentExprs, this.range);
        }
        throw new ShouldNotBeHereException("Unhandled macro type");
    }

    private AsmNode preParseStandardMacro(EvaluationState evaluationState, MacroDefinitionRootNode macroDefinitionRootNode) throws AsmException {
        this.macro = macroDefinitionRootNode;
        StringRangeList stringRangeList = macroDefinitionRootNode.getUserArgumentNames();
        if (stringRangeList.size() != this.argumentExprs.size()) {
            evaluationState.diagnosticMgr.add(new AsmError("Invalid number of arguments for macro", this.range));
            return EmptyOutput.instance;
        }
        if (this.labelId != null) {
            this.labelPageIdx = evaluationState.scopeMgr.resolveSymbol(this.labelId);
            this.labelPageIdx.replaceInitializer(LabelValue.getInitializer(evaluationState, () -> new ScopeValue(macroDefinitionRootNode.getInnerScope(), null)));
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) throws AsmException {
        IValueHolder[] iValueHolderArray;
        if (this.labelId == null) {
            iValueHolderArray = this.macro.getInnerScope().getSymbolTable().createPage();
        } else {
            LabelValue labelValue = (LabelValue)this.labelPageIdx.getValueHolder().getWithoutSideeffect();
            iValueHolderArray = ((ScopeValue)labelValue.getConnectedValue()).getSymbolPage();
        }
        return this.macro.instantiate(this.argumentExprs, null, iValueHolderArray, this.range).executePass(evaluationState);
    }

    private static class PluginMacroExecution
    extends AsmDirective {
        private IMacro macro;
        private List<ExprNode> argumentExprs;
        private SegmentMemoryBlock.Entry memEntry;

        public PluginMacroExecution(IMacro iMacro, List<ExprNode> list, SourceRange sourceRange) {
            super(sourceRange);
            this.macro = iMacro;
            this.argumentExprs = list;
        }

        @Override
        public AsmNode copy() {
            return new PluginMacroExecution(this.macro, this.argumentExprs, this.range);
        }

        @Override
        public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
            return this;
        }

        @Override
        public AsmNode executePrepass(EvaluationState evaluationState) {
            for (int i = 0; i < this.argumentExprs.size(); ++i) {
                this.argumentExprs.get(i).executePrepass(evaluationState);
            }
            return this;
        }

        @Override
        public AsmNode executePass(EvaluationState evaluationState) {
            Object object;
            if (this.memEntry == null) {
                this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
            }
            evaluationState.sideeffectMgr.clearFunctionSideOutput();
            IValue[] iValueArray = new IValue[this.argumentExprs.size()];
            boolean bl = false;
            for (int i = 0; i < iValueArray.length; ++i) {
                object = this.argumentExprs.get(i);
                Value value = this.argumentExprs.get(i).evaluate(evaluationState);
                bl |= value.isInvalid();
                iValueArray[i] = new PluginValue(value, ((ExprNode)object).getSourceRange());
            }
            if (bl) {
                return this;
            }
            PluginEngine pluginEngine = new PluginEngine(evaluationState, this.range);
            try {
                object = this.macro.execute(iValueArray, pluginEngine);
            }
            catch (Throwable throwable) {
                if (throwable instanceof AsmErrorException) {
                    throw (AsmErrorException)throwable;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                throwable.printStackTrace(printStream);
                evaluationState.log.println(byteArrayOutputStream.toString());
                throw new AsmErrorException("Exception while executing plugin macro", this.range);
            }
            if (object == null) {
                object = new byte[0];
            }
            evaluationState.segmentMgr.increaseMemoryPosition(((Object)object).length);
            this.memEntry.fillEntry((byte[])object, this.range);
            return SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
        }
    }
}

