/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.metanodes.NamespaceNode;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.state.EvaluationState;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;

public class NamespaceDirective
extends Directive {
    private AsmNode body;
    private NamespacePath nspath;

    public NamespaceDirective(AsmNode asmNode, NamespacePath namespacePath, SourceRange sourceRange) {
        super(sourceRange);
        this.body = asmNode;
        this.nspath = namespacePath;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl;
        Namespace namespace = evaluationState.namespaceMgr.getCurrentNamespace();
        boolean bl2 = bl = namespace.getScope() == evaluationState.scopeMgr.getCurrentScope();
        if (!bl) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't define a new namespace here. You have to be in the scope of a parent namespace (Not inside .if, .for, .function, etc.).", this.range));
            return EmptyOutput.instance;
        }
        Namespace namespace2 = evaluationState.namespaceMgr.resolveNSPathForDefinition(this.nspath, evaluationState);
        if (namespace2 == null) {
            return EmptyOutput.instance;
        }
        return new NamespaceNode(this.body, namespace2).executeMetaRegistrations(evaluationState);
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode copy() {
        return new NamespaceDirective(this.body.copy(), this.nspath, this.range);
    }
}

