/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.Collections;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmException;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.metanodes.AsmNodeList;
import kickass.pass.asmnode.metanodes.MacroDefinitionRootNode;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.state.EvaluationState;
import kickass.state.ScopePosition;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;
import kickass.state.scope.EntityScope;
import kickass.state.scope.ExecutableDirectives;

public class PseudoCommandDefinition
extends AsmDirective {
    private boolean isRootScope;
    private NamespacePath nspath;
    private ExecutableDirectives executableDir;
    private MacroDefinitionRootNode rootNode;

    public PseudoCommandDefinition(NamespacePath namespacePath, ExecutableDirectives executableDirectives, SourceRange sourceRange) {
        super(sourceRange);
        this.executableDir = executableDirectives;
        this.nspath = namespacePath;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) throws AsmException {
        boolean bl;
        boolean bl2 = bl = evaluationState.namespaceMgr.getCurrentNamespace().getScope() == evaluationState.scopeMgr.getCurrentScope();
        if (!bl) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't define a pseudo command here. Define it in the direct scope of the current namespace, not inside constructs like {}, .if, .for etc.", this.range));
            return EmptyOutput.instance;
        }
        Namespace namespace = evaluationState.namespaceMgr.resolveNSPathForDefinition(this.nspath, evaluationState);
        if (namespace == null) {
            return EmptyOutput.instance;
        }
        EntityScope<MacroDefinitionRootNode> entityScope = namespace.getPseudoCommands();
        String string = this.nspath.entityId;
        if (entityScope.getLocalDefinedEntities().containsKey(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("The pseudo command '" + string + "'  is already defined", this.range));
        }
        this.rootNode = new MacroDefinitionRootNode(this.executableDir.getArgumentNames(), Collections.emptyList(), new AsmNodeList(this.executableDir.getDirectives()), evaluationState.namespaceMgr.getCurrentNamespace(), ScopePosition.inPseudoCmd, this.range);
        entityScope.put(string, this.rootNode);
        this.rootNode.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.rootNode.executePrepass(evaluationState);
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) throws AsmException {
        throw new ShouldNotBeHereException();
    }
}

