/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.Collections;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.state.EvaluationState;
import kickass.state.c64output.C64File;
import kickass.state.c64output.C64FileType;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentParser;

public class SegmentDefDirective
extends AsmDirective {
    private boolean isDefOnly;
    private NamespacePath nspath;
    private ParameterMap parameters;
    private Segment segment = null;
    private boolean isFirstExec = true;

    public SegmentDefDirective(boolean bl, NamespacePath namespacePath, ParameterMap parameterMap, SourceRange sourceRange) {
        this(bl, namespacePath, parameterMap, sourceRange, null);
    }

    private SegmentDefDirective(boolean bl, NamespacePath namespacePath, ParameterMap parameterMap, SourceRange sourceRange, Segment segment) {
        super(sourceRange);
        this.isDefOnly = bl;
        this.nspath = namespacePath;
        this.parameters = parameterMap != null ? parameterMap : new ParameterMap(sourceRange);
        this.segment = segment;
    }

    @Override
    public AsmNode copy() {
        return new SegmentDefDirective(this.isDefOnly, this.nspath, this.parameters, this.range, this.segment);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        Namespace namespace = evaluationState.namespaceMgr.resolveNSPathForDefinition(this.nspath, evaluationState);
        if (namespace == null) {
            return this;
        }
        if (namespace.getSegements().getLocalDefinedEntities().containsKey(this.nspath.entityId)) {
            evaluationState.diagnosticMgr.add(new AsmError("Segment is already defined.", this.nspath.entityIdRange));
            return this;
        }
        String string = namespace.isSpecial ? "" : namespace.getFullName() + ".";
        String string2 = string + this.nspath.entityId;
        this.segment = new Segment(string2, this.range);
        namespace.getSegements().put(this.nspath.entityId, this.segment);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        SegmentParser.addErrorIfNotExists(this.parameters, Collections.emptySet(), true, evaluationState);
        SegmentParser.addErrorForUnknownParameters(this.parameters, SegmentParser.codeInputParameters, true, evaluationState);
        this.parameters.addErrorsForMutualExclusiveParameres(evaluationState, "start", "startAfter");
        this.parameters.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        boolean bl = this.parameters.evaluateAllParameters(evaluationState);
        boolean bl2 = this.parameters.anyInvalidValues(SegmentParser.codeInputParameters);
        if (bl2) {
            throw new AsmErrorException("All segment definition parameters must be valid in first pass", this.range);
        }
        if (this.isFirstExec) {
            C64File c64File;
            boolean bl3;
            if (this.segment.isInitialized) {
                throw new AsmErrorException("Segment is already initialized", this.range);
            }
            SegmentParser.fillCodeInputSegment(this.segment, this.parameters, evaluationState);
            if (this.segment.getOutPrg() != null && !(bl3 = evaluationState.c64OutputMgr.addC64File(c64File = new C64File(this.segment.getOutPrg(), this.segment)))) {
                throw new AsmErrorException("A file called '" + c64File.getFilename() + "' already exist", this.range);
            }
            if (this.segment.getOutBin() != null) {
                c64File = new C64File(this.segment.getOutBin(), this.segment);
                c64File.setType(C64FileType.bin);
                bl3 = evaluationState.c64OutputMgr.addC64File(c64File);
                if (!bl3) {
                    throw new AsmErrorException("A file called '" + c64File.getFilename() + "' already exist", this.range);
                }
            }
            this.segment.initPass();
            evaluationState.segmentMgr.addSegment(this.segment, evaluationState);
            this.isFirstExec = false;
            this.segment.isInitialized = true;
        }
        return bl ? this : SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

