/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.namespace.NamespacePath;
import kickass.state.segments.Segment;

public class SegmentDirective
extends AsmDirective {
    private NamespacePath nspath;
    private ExprNode memBlockNameExpr = null;
    private Segment segment;

    public SegmentDirective(NamespacePath namespacePath, ExprNode exprNode, SourceRange sourceRange) {
        this(namespacePath, exprNode, sourceRange, null);
    }

    private SegmentDirective(NamespacePath namespacePath, ExprNode exprNode, SourceRange sourceRange, Segment segment) {
        super(sourceRange);
        this.nspath = namespacePath;
        this.memBlockNameExpr = exprNode;
        this.segment = segment;
    }

    @Override
    public AsmNode copy() {
        return new SegmentDirective(this.nspath, this.memBlockNameExpr, this.range, this.segment);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        if (this.memBlockNameExpr != null) {
            this.memBlockNameExpr.executePrepass(evaluationState);
        }
        this.segment = evaluationState.segmentMgr.resolveSegment(this.nspath, evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        if (!this.segment.isInitialized) {
            throw new AsmErrorException("Segment not initialized. Make sure the definition is executed before using the segment.", this.range);
        }
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        String string = null;
        if (this.memBlockNameExpr != null) {
            Value value = this.memBlockNameExpr.evaluate(evaluationState);
            if (value.isInvalid()) {
                throw new AsmErrorException("Memblock name parameter must be valid in first pass", this.range);
            }
            string = value.getString(this.range);
        }
        evaluationState.segmentMgr.switchToSegment(this.segment);
        if (string != null) {
            evaluationState.segmentMgr.startSoftMemoryBlock(string, this.range);
        }
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

