/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.Arrays;
import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmException;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.metanodes.AsmNodeList;
import kickass.pass.asmnode.metanodes.MacroDefinitionRootNode;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.state.EvaluationState;
import kickass.state.ScopePosition;
import kickass.state.namespace.AnySegmentModifier;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;
import kickass.state.scope.EntityScope;

public class SegmentModifierDefinition
extends AsmDirective {
    private static List<String> autoIncludeArgNames = Arrays.asList("segment");
    private NamespacePath nspath;
    private StringRangeList userArgNames;
    private List<AsmNode> body;
    private MacroDefinitionRootNode rootNode;

    public SegmentModifierDefinition(NamespacePath namespacePath, StringRangeList stringRangeList, List<AsmNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.nspath = namespacePath;
        this.userArgNames = stringRangeList;
        this.body = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl;
        boolean bl2 = bl = evaluationState.namespaceMgr.getCurrentNamespace().getScope() == evaluationState.scopeMgr.getCurrentScope();
        if (!bl) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't define a segmentmodifier here. Define it in the direct scope of the current namespace, not inside constructs like {}, .if, .for etc.", this.range));
            return EmptyOutput.instance;
        }
        Namespace namespace = evaluationState.namespaceMgr.resolveNSPathForDefinition(this.nspath, evaluationState);
        if (namespace == null) {
            return EmptyOutput.instance;
        }
        EntityScope<AnySegmentModifier> entityScope = namespace.getSegmentModifiers();
        String string = this.nspath.entityId;
        if (entityScope.getLocalDefinedEntities().containsKey(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("The segmentmodifier '" + string + "'  is already defined", this.nspath.entityIdRange));
            return EmptyOutput.instance;
        }
        boolean bl3 = false;
        for (StringRange stringRange : this.userArgNames) {
            if (stringRange.string.startsWith("_")) continue;
            evaluationState.diagnosticMgr.add(new AsmError("Segmentmodifier argument names must start with '_': " + stringRange.string, stringRange.range));
            bl3 = true;
        }
        if (bl3) {
            return EmptyOutput.instance;
        }
        this.rootNode = new MacroDefinitionRootNode(this.userArgNames, autoIncludeArgNames, new AsmNodeList(this.body), evaluationState.namespaceMgr.getCurrentNamespace(), ScopePosition.inSegmentModifier, this.range);
        entityScope.put(string, new AnySegmentModifier(this.rootNode));
        this.rootNode.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.rootNode.executePrepass(evaluationState);
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) throws AsmException {
        throw new ShouldNotBeHereException();
    }
}

