/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.ArrayList;
import java.util.HashSet;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.directives.misc.StructConstructor;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.function.functionselector.SingleFunctionAnyArgSelector;
import kickass.state.EvaluationState;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;

public class StructDirective
extends AsmDirective {
    private NamespacePath nspath;
    private StringRangeList variableNames;

    public StructDirective(NamespacePath namespacePath, StringRangeList stringRangeList, SourceRange sourceRange) {
        super(sourceRange);
        this.nspath = namespacePath;
        this.variableNames = stringRangeList;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        Namespace namespace = evaluationState.namespaceMgr.resolveNSPathForDefinition(this.nspath, evaluationState);
        if (namespace == null) {
            return null;
        }
        boolean bl = namespace.getFunctions().getLocalDefinedEntities().containsKey(this.nspath.entityId);
        if (bl) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't define constructor for the struct '" + String.valueOf(this.nspath) + "'. The function name is already used", this.range));
            return EmptyOutput.instance;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (StringRange stringRange : this.variableNames) {
            if (hashSet.contains(stringRange.string)) {
                evaluationState.diagnosticMgr.add(new AsmError("A field of that name is already defined : " + stringRange.string, stringRange.range));
                return EmptyOutput.instance;
            }
            hashSet.add(stringRange.string);
        }
        StructConstructor structConstructor = new StructConstructor(this.nspath.entityId, new ArrayList<String>(hashSet));
        namespace.getFunctions().put(structConstructor.getName(), new SingleFunctionAnyArgSelector(structConstructor));
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }
}

