/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.ReturnException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.function.Function;
import kickass.pass.functionnode.FunctionNode;
import kickass.pass.functionnode.FunctionNodeList;
import kickass.pass.valueholder.FunctionVariableValueHolder;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.NullValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.ScopePosition;
import kickass.state.namespace.Namespace;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.ISymbolTable;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.scope.symboltable.SymbolTable;

class UserFunction
extends Function {
    private StringRangeList argumentNames;
    private FunctionNode body;
    private Namespace definitionNamespace;
    private SymbolScope innerScope;
    private SourceRange range;
    private ISymbolTable symbolTable;
    private ISymbolPageIdx[] argSymbolIdxs;

    protected UserFunction(String string, StringRangeList stringRangeList, List<FunctionNode> list, Namespace namespace, SourceRange sourceRange) {
        super(string, stringRangeList.size(), null, true);
        this.range = sourceRange;
        this.argumentNames = stringRangeList;
        this.definitionNamespace = namespace;
        this.body = new FunctionNodeList(list);
        this.symbolTable = new SymbolTable();
        this.innerScope = new SymbolScope(namespace.getScope(), this.symbolTable);
        this.innerScope.setScopePosition(ScopePosition.inFunction);
    }

    public void registerMetaDefinitions(EvaluationState evaluationState) {
        this.argSymbolIdxs = new ISymbolPageIdx[this.argumentNames.size()];
        for (int i = 0; i < this.argumentNames.size(); ++i) {
            StringRange stringRange = (StringRange)this.argumentNames.get(i);
            if (this.innerScope.isDefined(stringRange.string)) {
                evaluationState.diagnosticMgr.add(new AsmError("The symbol '" + stringRange.string + "' is already defined.", stringRange.range));
            }
            this.argSymbolIdxs[i] = this.innerScope.define(stringRange.string, FunctionVariableValueHolder.initializer);
            this.argSymbolIdxs[i].setStatus(SymbolStatus.defined);
        }
        SymbolScope symbolScope = evaluationState.scopeMgr.replaceCurrentScope(this.innerScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
    }

    public void executePrepass(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.replaceCurrentScope(this.innerScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
    }

    @Override
    public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        IValueHolder[] iValueHolderArray = this.symbolTable.replaceCurrentPage(this.symbolTable.createPage());
        Namespace namespace = evaluationState.namespaceMgr.replaceCurrentNamespace(this.definitionNamespace);
        for (int i = 0; i < this.argSymbolIdxs.length; ++i) {
            this.argSymbolIdxs[i].getValueHolder().setWithoutSideEffect(valueArray[i]);
        }
        Value value = NullValue.instance;
        try {
            this.body.executeFunctionPass(evaluationState);
        }
        catch (ReturnException returnException) {
            value = returnException.getReturnValue();
        }
        this.symbolTable.setCurrentPage(iValueHolderArray);
        evaluationState.namespaceMgr.setCurrentNamespace(namespace);
        return value;
    }
}

