/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives.misc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.exceptions.AsmException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.values.StructValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class StructConstructor
extends Function {
    private List<String> fieldNames;
    private Map<String, Integer> nameToFieldPos = null;

    public StructConstructor(String string, List<String> list) {
        super(string, null, null, true);
        this.fieldNames = list;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public Map<String, Integer> getNameToFieldPositionMap() {
        if (this.nameToFieldPos != null) {
            return this.nameToFieldPos;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            hashMap.put(this.fieldNames.get(i), i);
        }
        this.nameToFieldPos = hashMap;
        return hashMap;
    }

    @Override
    public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) throws AsmException {
        StructValue structValue = null;
        if (valueArray.length == 0) {
            structValue = new StructValue(this.getName(), this.fieldNames, null);
        }
        if (valueArray.length == this.fieldNames.size()) {
            structValue = new StructValue(this.getName(), this.fieldNames, valueArray);
        }
        if (structValue == null) {
            throw new AsmErrorException("Invalid number of arguments for struct constructor", sourceRange);
        }
        return structValue;
    }
}

