/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.metanodes;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.metanodes.MacroInstanceRootNode;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.valueholder.VariableValueHolder;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.ScopePosition;
import kickass.state.namespace.Namespace;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.scope.symboltable.SymbolTable;

public class MacroDefinitionRootNode
extends AsmNode {
    private StringRangeList userArgNames;
    private List<String> autoIncludeArgNames = null;
    private SourceRange range;
    private AsmNode body;
    private Namespace definitionNamespace;
    private SymbolScope innerScope;
    private SymbolTable symbolTable;
    private ISymbolPageIdx[] argSymbolIdxs;
    private Set<String> userArgNamesSet = null;

    public MacroDefinitionRootNode(StringRangeList stringRangeList, List<String> list, AsmNode asmNode, Namespace namespace, ScopePosition scopePosition, SourceRange sourceRange) {
        this.userArgNames = stringRangeList;
        this.autoIncludeArgNames = list;
        this.body = asmNode;
        this.range = sourceRange;
        this.definitionNamespace = namespace;
        this.symbolTable = new SymbolTable();
        this.innerScope = new SymbolScope(namespace.getScope(), this.symbolTable);
        this.innerScope.setScopePosition(scopePosition);
    }

    public Set<String> getUserArgNamesSet() {
        if (this.userArgNamesSet == null) {
            this.userArgNamesSet = new HashSet<String>();
        }
        for (StringRange stringRange : this.userArgNames) {
            this.userArgNamesSet.add(stringRange.string);
        }
        return this.userArgNamesSet;
    }

    public StringRangeList getUserArgumentNames() {
        return this.userArgNames;
    }

    public SymbolScope getInnerScope() {
        return this.innerScope;
    }

    public MacroInstanceRootNode instantiate(List<ExprNode> list, Value value, IValueHolder[] iValueHolderArray, SourceRange sourceRange) {
        return new MacroInstanceRootNode(this.body.copy(), this.symbolTable, this.argSymbolIdxs, iValueHolderArray, this.definitionNamespace, list, value, sourceRange);
    }

    @Override
    public AsmNode copy() {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = this.innerScope;
        this.argSymbolIdxs = new ISymbolPageIdx[this.autoIncludeArgNames.size() + this.userArgNames.size()];
        int n = 0;
        for (String object : this.autoIncludeArgNames) {
            if (symbolScope.isDefined(object)) {
                evaluationState.diagnosticMgr.add(new AsmError("The symbol is already defined", this.range));
            }
            this.argSymbolIdxs[n++] = symbolScope.define(object, VariableValueHolder.initializer).setStatus(SymbolStatus.defined);
        }
        for (StringRange stringRange : this.userArgNames) {
            if (symbolScope.isDefined(stringRange.string)) {
                evaluationState.diagnosticMgr.add(new AsmError("The symbol is already defined", stringRange.range));
            }
            this.argSymbolIdxs[n++] = symbolScope.define(stringRange.string, VariableValueHolder.initializer).setStatus(SymbolStatus.defined);
        }
        SymbolScope symbolScope2 = evaluationState.scopeMgr.replaceCurrentScope(this.innerScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope2);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.replaceCurrentScope(this.innerScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
    }

    @Override
    public boolean isFinished() {
        return true;
    }
}

