/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.pass.expressions.expr.DeReference;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.expr.foreach.ForeachBlock;
import kickass.pass.expressions.expr.foreach.ForeachEvaluator;
import kickass.pass.expressions.refexpr.SymbolReferenceExpr;
import kickass.pass.values.HashtableValue;
import kickass.pass.values.ListValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ForeachGroupByExpr
extends ExprNode {
    private ExprNode valueExpr;
    private ExprNode groupByExpr;
    private ForeachEvaluator foreachEval;

    public ForeachGroupByExpr(ExprNode exprNode, ExprNode exprNode2, ForeachBlock foreachBlock, SourceRange sourceRange) {
        super(sourceRange);
        this.valueExpr = exprNode;
        this.groupByExpr = exprNode2;
        this.foreachEval = new ForeachEvaluator(foreachBlock);
        if (this.valueExpr == null) {
            ForeachBlock foreachBlock2 = foreachBlock.getInnermost();
            if (foreachBlock2.iterIds.size() == 1) {
                StringRange stringRange = (StringRange)foreachBlock2.iterIds.getFirst();
                this.valueExpr = new DeReference(new SymbolReferenceExpr(stringRange.string, stringRange.range));
            }
        }
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        this.foreachEval.executePrepass(evaluationState, () -> {
            if (this.valueExpr != null) {
                this.valueExpr.executePrepass(evaluationState);
            }
            this.groupByExpr.executePrepass(evaluationState);
        });
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        HashMap hashMap = new HashMap();
        boolean bl = this.foreachEval.evaluate(evaluationState, () -> {
            String string = this.groupByExpr.evaluate(evaluationState).getString(this.groupByExpr.range);
            ArrayList<Value> arrayList = (ArrayList<Value>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Value>();
                hashMap.put(string, arrayList);
            }
            Value value = this.valueExpr.evaluate(evaluationState);
            arrayList.add(value);
        });
        if (!bl) {
            return HashtableValue.invalid;
        }
        HashtableValue hashtableValue = new HashtableValue();
        for (Map.Entry entry : hashMap.entrySet()) {
            ListValue listValue = new ListValue(((ArrayList)entry.getValue()).iterator());
            hashtableValue.putValue((String)entry.getKey(), listValue);
        }
        return hashtableValue;
    }
}

