/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.expr.foreach.ForeachBlock;
import kickass.pass.expressions.expr.foreach.ForeachEvaluator;
import kickass.pass.expressions.expr.misc.ExprPair;
import kickass.pass.values.HashtableValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ForeachHashtableExpr
extends ExprNode {
    private ExprPair keyValueExprs;
    private ForeachEvaluator foreachEval;

    public ForeachHashtableExpr(ExprPair exprPair, ForeachBlock foreachBlock, SourceRange sourceRange) {
        super(sourceRange);
        this.keyValueExprs = exprPair;
        this.foreachEval = new ForeachEvaluator(foreachBlock);
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        this.foreachEval.executePrepass(evaluationState, () -> {
            this.keyValueExprs.a.executePrepass(evaluationState);
            this.keyValueExprs.b.executePrepass(evaluationState);
        });
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        HashtableValue hashtableValue = new HashtableValue();
        boolean bl = this.foreachEval.evaluate(evaluationState, () -> {
            String string = this.keyValueExprs.a.evaluate(evaluationState).getString(this.keyValueExprs.a.range);
            Value value = this.keyValueExprs.b.evaluate(evaluationState);
            hashtableValue.putValue(string, value);
        });
        if (!bl) {
            return HashtableValue.invalid;
        }
        return hashtableValue;
    }
}

