/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import java.util.List;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.expr.misc.ExprPair;
import kickass.pass.values.HashtableValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class HashtableExpr
extends ExprNode {
    private List<ExprPair> kvpairs;

    public HashtableExpr(List<ExprPair> list, SourceRange sourceRange) {
        super(sourceRange);
        this.kvpairs = list;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        for (int i = 0; i < this.kvpairs.size(); ++i) {
            this.kvpairs.get((int)i).a.executePrepass(evaluationState);
            this.kvpairs.get((int)i).b.executePrepass(evaluationState);
        }
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        HashtableValue hashtableValue = new HashtableValue();
        for (int i = 0; i < this.kvpairs.size(); ++i) {
            ExprPair exprPair = this.kvpairs.get(i);
            String string = exprPair.a.evaluate(evaluationState).getString(exprPair.a.range);
            Value value = exprPair.b.evaluate(evaluationState);
            hashtableValue.putValue(string, value);
        }
        return hashtableValue;
    }
}

