/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.valueholder.FunctionVariableValueHolder;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.Value;
import kickass.pass.values.interfaces.ICallable;
import kickass.state.EvaluationState;
import kickass.state.ScopePosition;
import kickass.state.namespace.Namespace;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.ISymbolTable;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.scope.symboltable.SymbolTable;

class LambdaFunction
implements ICallable {
    private StringRangeList argumentNamesAndRange;
    private List<String> argumentNames = null;
    private ExprNode expr;
    private SourceRange range;
    private Namespace definitionNamespace;
    private SymbolScope innerScope;
    private ISymbolTable symbolTable;
    private ISymbolPageIdx[] argSymbolIdxs;

    protected LambdaFunction(StringRangeList stringRangeList, ExprNode exprNode, SourceRange sourceRange) {
        this.range = sourceRange;
        this.argumentNamesAndRange = stringRangeList;
        this.expr = exprNode;
    }

    private String getArgumentsList() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        boolean bl = true;
        for (StringRange stringRange : this.argumentNamesAndRange) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringRange.string);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void registerMetaDefinitions(EvaluationState evaluationState) {
        this.definitionNamespace = evaluationState.namespaceMgr.getCurrentNamespace();
        this.symbolTable = new SymbolTable();
        this.innerScope = new SymbolScope(evaluationState.scopeMgr.getCurrentScope(), this.symbolTable);
        this.innerScope.setScopePosition(ScopePosition.inLambdaExpression);
        this.argSymbolIdxs = new ISymbolPageIdx[this.argumentNamesAndRange.size()];
        for (int i = 0; i < this.argumentNamesAndRange.size(); ++i) {
            StringRange stringRange = (StringRange)this.argumentNamesAndRange.get(i);
            if (this.innerScope.isDefined(stringRange.string)) {
                evaluationState.diagnosticMgr.add(new AsmError("The symbol '" + stringRange.string + "' is already defined.", stringRange.range));
            }
            this.argSymbolIdxs[i] = this.innerScope.define(stringRange.string, FunctionVariableValueHolder.initializer);
            this.argSymbolIdxs[i].setStatus(SymbolStatus.defined);
        }
    }

    public void executePrepass(EvaluationState evaluationState) {
        this.registerMetaDefinitions(evaluationState);
        if (evaluationState.scopeMgr.getCurrentScope().getScopePosition() == ScopePosition.inLambdaExpression) {
            evaluationState.diagnosticMgr.add(new AsmError("You can't define a lamda inside a lambda currently. It might be implemented in later versions.", this.range));
        }
        SymbolScope symbolScope = evaluationState.scopeMgr.replaceCurrentScope(this.innerScope);
        this.expr.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
    }

    @Override
    public boolean isCallable() {
        return true;
    }

    @Override
    public boolean isCallable(int n) {
        return n == this.argumentNamesAndRange.size();
    }

    @Override
    public Value call(int n, Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        int n2 = valueArray.length - n;
        if (n2 != this.argumentNamesAndRange.size()) {
            if (n2 > this.argumentNamesAndRange.size()) {
                throw new AsmErrorException("Too many arguments for lambda. The arguments should be: " + this.getArgumentsList(), sourceRange);
            }
            throw new AsmErrorException("Too few arguments for lambda. The arguments should be: " + this.getArgumentsList(), sourceRange);
        }
        IValueHolder[] iValueHolderArray = this.symbolTable.replaceCurrentPage(this.symbolTable.createPage());
        Namespace namespace = evaluationState.namespaceMgr.replaceCurrentNamespace(this.definitionNamespace);
        for (int i = 0; i < this.argSymbolIdxs.length; ++i) {
            this.argSymbolIdxs[i].getValueHolder().setWithoutSideEffect(valueArray[i + n]);
        }
        Value value = this.expr.evaluate(evaluationState);
        this.symbolTable.setCurrentPage(iValueHolderArray);
        evaluationState.namespaceMgr.setCurrentNamespace(namespace);
        return value;
    }

    @Override
    public List<String> getArgumentNames() {
        if (this.argumentNames == null) {
            this.argumentNames = this.argumentNamesAndRange.getStringList();
        }
        return this.argumentNames;
    }
}

