/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.refexpr.IReferenceExpr;
import kickass.pass.expressions.refexpr.ReferenceOperation;
import kickass.pass.function.IFunction;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class OperatorTimesEqual
extends ExprNode {
    private ExprNode expr;
    private IReferenceExpr refExpr;

    public OperatorTimesEqual(IReferenceExpr iReferenceExpr, ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.expr = exprNode;
        this.refExpr = iReferenceExpr;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        this.refExpr.executePrepass(evaluationState, ReferenceOperation.readAndWrite);
        this.expr.executePrepass(evaluationState);
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        IValueHolder iValueHolder = this.refExpr.getValueHolder(evaluationState);
        Value value = iValueHolder.get(evaluationState, this.range);
        Value value2 = this.expr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return value;
        }
        Value[] valueArray = new Value[]{value, value2};
        IFunction iFunction = value.getFunctions().getOrError("*", 2, this.range);
        Value value3 = value2.isInvalid() && !iFunction.handlesInvalidArguments() ? iFunction.getInvalidResult(valueArray) : iFunction.execute(valueArray, evaluationState, this.range);
        iValueHolder.set(value3, evaluationState, this.range);
        return value3;
    }
}

