/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ShorCircuitedOperatorCall
extends ExprNode {
    private String functionName;
    private Operator operator;
    private ExprNode arg1Expr;
    private ExprNode arg2Expr;

    public ShorCircuitedOperatorCall(String string, SourceRange sourceRange, ExprNode exprNode, ExprNode exprNode2) {
        super(sourceRange);
        this.functionName = string;
        this.arg1Expr = exprNode;
        this.arg2Expr = exprNode2;
        if (string.equals("&&")) {
            this.operator = Operator.and;
        } else if (string.equals("||")) {
            this.operator = Operator.or;
        } else {
            throw new AsmErrorException("Unknow operator " + String.valueOf((Object)this.operator), sourceRange);
        }
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        this.arg1Expr.executePrepass(evaluationState);
        this.arg2Expr.executePrepass(evaluationState);
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        boolean bl;
        Value value = this.arg1Expr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return BooleanValue.invalid;
        }
        boolean bl2 = value.getBoolean(this.range);
        if (this.operator == Operator.and && !bl2) {
            return BooleanValue.falseValue;
        }
        if (this.operator == Operator.or && bl2) {
            return BooleanValue.trueValue;
        }
        Value value2 = this.arg2Expr.evaluate(evaluationState);
        if (value2.isInvalid()) {
            return BooleanValue.invalid;
        }
        boolean bl3 = value2.getBoolean(this.range);
        if (this.operator == Operator.and) {
            bl = bl2 && bl3;
        } else if (this.operator == Operator.or) {
            bl = bl2 || bl3;
        } else {
            throw new AsmErrorException("Unknow operator " + String.valueOf((Object)this.operator), this.range);
        }
        return BooleanValue.get(bl);
    }

    public String toString() {
        return this.functionName;
    }

    public static enum Operator {
        and,
        or;

    }
}

