/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.baselang.tokens.RangeToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.PeekTokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.misc.NamespacePathParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.directives.misc.StructConstructor;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.expr.misc.StringExprPair;
import kickass.pass.function.Function;
import kickass.pass.function.functionselector.IFunctionSelector;
import kickass.pass.values.NullValue;
import kickass.pass.values.StructValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;

public class StructExpr
extends ExprNode {
    private boolean isAnonynous;
    private RangeToken hashRange;
    private List<StringExprPair> fvpairs;
    private String structName;
    private Map<String, Integer> fieldPositionMap;
    private List<String> orderedFieldNames;

    public StructExpr(RangeToken rangeToken, List<StringExprPair> list, SourceRange sourceRange) {
        super(sourceRange);
        this.fvpairs = list;
        this.hashRange = rangeToken;
        this.isAnonynous = rangeToken.getChildren().isEmpty();
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        if (this.isAnonynous) {
            this.preparseAnonymousStruct();
        } else {
            this.preparesKnownStruct(evaluationState);
        }
        for (int i = 0; i < this.fvpairs.size(); ++i) {
            this.fvpairs.get((int)i).expr.executePrepass(evaluationState);
        }
    }

    private void preparseAnonymousStruct() {
        this.structName = "";
        this.fieldPositionMap = new HashMap<String, Integer>();
        this.orderedFieldNames = new ArrayList<String>();
        for (int i = 0; i < this.fvpairs.size(); ++i) {
            String string = this.fvpairs.get((int)i).str;
            this.orderedFieldNames.add(string);
            this.fieldPositionMap.put(string, i);
        }
    }

    private void preparesKnownStruct(EvaluationState evaluationState) {
        NamespacePath namespacePath;
        Object object;
        try {
            object = new PeekTokenStream(new TokenStreamList(this.hashRange.getChildren(), this.hashRange.getRangeEndToken()));
            namespacePath = NamespacePathParser.parse((ITokenStream)object, true, evaluationState);
            if (namespacePath == null) {
                return;
            }
        }
        catch (IOException iOException) {
            evaluationState.diagnosticMgr.add(new AsmError("Error while parsing namespace path: " + iOException.getMessage(), this.range));
            return;
        }
        this.structName = namespacePath.entityId;
        object = evaluationState.namespaceMgr.resolveNSPathForExtraction(namespacePath, evaluationState);
        if (object == null) {
            return;
        }
        IFunctionSelector iFunctionSelector = ((Namespace)object).getFunctions().get(namespacePath.entityId);
        if (iFunctionSelector == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Struct not defined: " + String.valueOf(namespacePath), namespacePath.entityIdRange));
            return;
        }
        Function function = iFunctionSelector.getFunction(0);
        if (function == null || !(function instanceof StructConstructor)) {
            evaluationState.diagnosticMgr.add(new AsmError("Entity not is not a struct: " + String.valueOf(namespacePath), namespacePath.entityIdRange));
            return;
        }
        StructConstructor structConstructor = (StructConstructor)function;
        this.fieldPositionMap = structConstructor.getNameToFieldPositionMap();
        this.orderedFieldNames = structConstructor.getFieldNames();
        for (int i = 0; i < this.fvpairs.size(); ++i) {
            String string = this.fvpairs.get((int)i).str;
            if (this.fieldPositionMap.containsKey(string)) continue;
            SourceRange sourceRange = this.fvpairs.get((int)i).strRange;
            evaluationState.diagnosticMgr.add(new AsmError("Unknown field: " + string, sourceRange));
        }
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Object[] objectArray = new Value[this.fieldPositionMap.size()];
        Arrays.fill(objectArray, NullValue.instance);
        for (int i = 0; i < this.fvpairs.size(); ++i) {
            StringExprPair stringExprPair = this.fvpairs.get(i);
            String string = stringExprPair.str;
            Value value = stringExprPair.expr.evaluate(evaluationState);
            Integer n = this.fieldPositionMap.get(string);
            objectArray[n.intValue()] = value;
        }
        return new StructValue(this.structName, this.orderedFieldNames, (Value[])objectArray);
    }
}

