/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr.foreach;

import kickass.common.diagnostics.AsmError;
import kickass.nonasm.util.functions.Action0;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.expr.foreach.ForeachBlock;
import kickass.pass.expressions.expr.foreach.ForeachEvaluatorState;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.valueholder.VariableValueHolder;
import kickass.pass.values.NullValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.pass.values.valueiterator.IValueIterator;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.ISymbolTable;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.scope.symboltable.SymbolTable;

public class ForeachEvaluator {
    private ForeachBlock foreach;
    private ISymbolTable symbolTable;

    public ForeachEvaluator(ForeachBlock foreachBlock) {
        this.foreach = foreachBlock;
    }

    public ISymbolPageIdx defineInScope(StringRange stringRange, EvaluationState evaluationState) {
        ISymbolPageIdx iSymbolPageIdx = evaluationState.scopeMgr.getCurrentScope().defineErrorIfExist(stringRange.string, VariableValueHolder.initializer, evaluationState, "Symbol already defined: " + String.valueOf(stringRange), stringRange.range);
        iSymbolPageIdx.setStatus(SymbolStatus.defined);
        return iSymbolPageIdx;
    }

    public void executePrepass(EvaluationState evaluationState, Action0 action0) {
        this.symbolTable = new SymbolTable();
        this.executePrepass(evaluationState, this.foreach, action0);
    }

    private void executePrepass(EvaluationState evaluationState, ForeachBlock foreachBlock, Action0 action0) {
        if (foreachBlock.iterIds.size() != foreachBlock.iterExprs.size()) {
            evaluationState.diagnosticMgr.add(new AsmError("Number of itererators does not match the number of variables names", foreachBlock.iterExprs.getLast().getSourceRange()));
        }
        for (ExprNode object2 : foreachBlock.iterExprs) {
            object2.executePrepass(evaluationState);
        }
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        SymbolScope symbolScope2 = new SymbolScope(symbolScope, this.symbolTable);
        evaluationState.scopeMgr.setCurrentScope(symbolScope2);
        if (foreachBlock.enumerationId != null) {
            foreachBlock.enumeratorSymbolPageIdx = this.defineInScope(foreachBlock.enumerationId, evaluationState);
        }
        int n = 0;
        foreachBlock.iterVarSymbolPageIdxs = new ISymbolPageIdx[foreachBlock.iterIds.size()];
        for (StringRange stringRange : foreachBlock.iterIds) {
            foreachBlock.iterVarSymbolPageIdxs[n++] = this.defineInScope(stringRange, evaluationState);
        }
        if (foreachBlock.ifExpr != null) {
            foreachBlock.ifExpr.executePrepass(evaluationState);
        }
        if (foreachBlock.nestedBlock == null) {
            action0.apply();
        } else {
            this.executePrepass(evaluationState, foreachBlock.nestedBlock, action0);
        }
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
    }

    public boolean evaluate(EvaluationState evaluationState, Action0 action0) {
        return this.evaluate(evaluationState, null, action0);
    }

    public boolean evaluate(EvaluationState evaluationState, ForeachEvaluatorState foreachEvaluatorState, Action0 action0) {
        IValueHolder[] iValueHolderArray = this.symbolTable.replaceCurrentPage(this.symbolTable.createPage());
        boolean bl = this.evaluate(evaluationState, foreachEvaluatorState, this.foreach, action0);
        this.symbolTable.setCurrentPage(iValueHolderArray);
        return bl;
    }

    private boolean evaluate(EvaluationState evaluationState, ForeachEvaluatorState foreachEvaluatorState, ForeachBlock foreachBlock, Action0 action0) {
        Value value;
        int n;
        IValueIterator[] iValueIteratorArray = new IValueIterator[foreachBlock.iterExprs.size()];
        for (n = 0; n < foreachBlock.iterExprs.size(); ++n) {
            ExprNode exprNode = foreachBlock.iterExprs.get(n);
            value = exprNode.evaluate(evaluationState);
            if (value.isInvalid()) {
                return false;
            }
            iValueIteratorArray[n] = value.getIterator(exprNode.getSourceRange());
        }
        n = 0;
        while (true) {
            block15: {
                int n2;
                block14: {
                    if (foreachBlock.enumerationId != null) {
                        IValueHolder iValueHolder = foreachBlock.enumeratorSymbolPageIdx.getValueHolder();
                        iValueHolder.setWithoutSideEffect(new NumberValue(n));
                    }
                    boolean bl = false;
                    value = null;
                    for (n2 = 0; n2 < foreachBlock.iterExprs.size(); ++n2) {
                        SourceRange sourceRange = foreachBlock.iterExprs.get(n2).getSourceRange();
                        IValueIterator iValueIterator = iValueIteratorArray[n2];
                        boolean bl2 = iValueIterator.hasNext();
                        value = bl2 ? iValueIterator.next(sourceRange) : NullValue.instance;
                        bl |= bl2;
                        IValueHolder iValueHolder = foreachBlock.iterVarSymbolPageIdxs[n2].getValueHolder();
                        iValueHolder.setWithoutSideEffect(value);
                    }
                    if (!bl) break;
                    if (foreachBlock.ifExpr == null) break block14;
                    Value value2 = foreachBlock.ifExpr.evaluate(evaluationState);
                    if (value2.isInvalid()) {
                        return false;
                    }
                    if (!value2.getBoolean(foreachBlock.ifExpr.getSourceRange())) break block15;
                }
                if (foreachBlock.nestedBlock == null) {
                    if (foreachEvaluatorState != null) {
                        foreachEvaluatorState.current = value;
                    }
                    action0.apply();
                    if (foreachEvaluatorState != null) {
                        foreachEvaluatorState.isFirst = false;
                    }
                } else {
                    n2 = this.evaluate(evaluationState, foreachEvaluatorState, foreachBlock.nestedBlock, action0) ? 1 : 0;
                    if (n2 == 0) {
                        return false;
                    }
                }
            }
            ++n;
        }
        return true;
    }
}

