/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr.misc;

import java.util.ArrayList;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.expressions.expr.DeReference;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.refexpr.SymbolReferenceExpr;
import kickass.state.EvaluationState;

public class ExprCommaList {
    public boolean trailingComma = false;
    public SourceRange startRange = null;
    public SourceRange endRange = null;
    public ArrayList<ExprNode> list = new ArrayList();

    public ExprCommaList add(ExprNode exprNode) {
        this.list.add(exprNode);
        return this;
    }

    public ExprCommaList setRanges(SourceRange sourceRange, SourceRange sourceRange2) {
        this.startRange = sourceRange;
        this.endRange = sourceRange2;
        return this;
    }

    public ExprCommaList setTrailingComma(boolean bl) {
        this.trailingComma = bl;
        return this;
    }

    public ExprNode GetUnparentExprOrTuppleExpr(EvaluationState evaluationState) {
        boolean bl;
        boolean bl2 = bl = this.list.size() == 1 && !this.trailingComma;
        if (bl) {
            return this.list.getFirst();
        }
        if (this.list.isEmpty()) {
            evaluationState.diagnosticMgr.add(new AsmError("Syntax error", this.startRange));
            return null;
        }
        if (this.list.size() == 1 && this.trailingComma) {
            evaluationState.diagnosticMgr.add(new AsmError("Syntax error", this.endRange));
            return null;
        }
        evaluationState.diagnosticMgr.add(new AsmError("Syntax error", this.list.get(1).getSourceRange()));
        return null;
    }

    public StringRangeList getIdList(EvaluationState evaluationState) {
        StringRangeList stringRangeList = new StringRangeList();
        for (ExprNode exprNode : this.list) {
            if (!(exprNode instanceof DeReference)) {
                evaluationState.diagnosticMgr.add(new AsmError("Invalid argument", exprNode.getSourceRange()));
                return stringRangeList;
            }
            DeReference deReference = (DeReference)exprNode;
            if (!(deReference.referenceExpr instanceof SymbolReferenceExpr)) {
                evaluationState.diagnosticMgr.add(new AsmError("Invalid argument", deReference.getSourceRange()));
                return stringRangeList;
            }
            String string = ((SymbolReferenceExpr)deReference.referenceExpr).rawName;
            SourceRange sourceRange = deReference.referenceExpr.getSourceRange();
            stringRangeList.add(new StringRange(string, sourceRange));
        }
        return stringRangeList;
    }
}

